/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.StaEDIFilteredStreamReader;
import io.xlate.edi.internal.stream.StaEDIStreamReader;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIInputFactory;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamFilter;
import io.xlate.edi.stream.EDIStreamReader;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class StaEDIInputFactory
extends EDIInputFactory {
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private final Set<String> supportedCharsets;

    public StaEDIInputFactory() {
        this.supportedProperties.add("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_STRUCTURE");
        this.supportedCharsets = new HashSet<String>();
        this.supportedCharsets.add(DEFAULT_ENCODING);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream) {
        return this.createEDIStreamReader(stream, (Schema)null);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, String encoding) throws EDIStreamException {
        return this.createEDIStreamReader(stream, encoding, null);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, Schema schema) {
        return new StaEDIStreamReader(stream, DEFAULT_ENCODING, schema, this.properties);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, String encoding, Schema schema) throws EDIStreamException {
        Objects.requireNonNull(stream);
        if (this.supportedCharsets.contains(encoding)) {
            return new StaEDIStreamReader(stream, encoding, schema, this.properties);
        }
        throw new EDIStreamException("Unsupported encoding: " + encoding);
    }

    @Override
    public EDIStreamReader createFilteredReader(EDIStreamReader reader, EDIStreamFilter filter) {
        return new StaEDIFilteredStreamReader(reader, filter);
    }
}

