/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.StaEDIStreamWriter;
import io.xlate.edi.stream.EDIOutputFactory;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamWriter;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class StaEDIOutputFactory
extends EDIOutputFactory {
    private static final String DEFAULT_ENCODING = "US-ASCII";
    private final Set<String> supportedCharsets = new HashSet<String>();

    public StaEDIOutputFactory() {
        this.supportedCharsets.add(DEFAULT_ENCODING);
        this.supportedProperties.add("io.xlate.edi.stream.delim.segment");
        this.supportedProperties.add("io.xlate.edi.stream.delim.dataElement");
        this.supportedProperties.add("io.xlate.edi.stream.delim.componentElement");
        this.supportedProperties.add("io.xlate.edi.stream.delim.repetition");
        this.supportedProperties.add("io.xlate.edi.stream.delim.decimal");
        this.supportedProperties.add("io.xlate.edi.stream.delim.release");
        this.supportedProperties.add("io.xlate.edi.stream.PRETTY_PRINT");
        this.properties.put("io.xlate.edi.stream.PRETTY_PRINT", Boolean.FALSE);
    }

    @Override
    public EDIStreamWriter createEDIStreamWriter(OutputStream stream) {
        return new StaEDIStreamWriter(stream, DEFAULT_ENCODING, this.properties);
    }

    @Override
    public EDIStreamWriter createEDIStreamWriter(OutputStream stream, String encoding) throws EDIStreamException {
        if (this.supportedCharsets.contains(encoding)) {
            return new StaEDIStreamWriter(stream, encoding, this.properties);
        }
        throw new EDIStreamException("Unsupported encoding: " + encoding);
    }
}

