/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamReader;
import io.xlate.edi.stream.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Base64;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaEDIXMLStreamReader
implements XMLStreamReader {
    private static final javax.xml.stream.Location location = new DefaultLocation();
    private static final QName DUMMY_QNAME = new QName("DUMMY");
    private static final QName INTERCHANGE = new QName("INTERCHANGE");
    private final EDIStreamReader ediReader;
    private final Queue<Integer> eventQueue = new ArrayDeque<Integer>(3);
    private final Queue<QName> elementQueue = new ArrayDeque<QName>(3);
    private final Deque<QName> elementStack = new ArrayDeque<QName>();
    private final StringBuilder cdataBuilder = new StringBuilder();
    private char[] cdata;

    public StaEDIXMLStreamReader(EDIStreamReader ediReader) throws XMLStreamException {
        this.ediReader = ediReader;
        if (ediReader.getEventType() == EDIStreamEvent.START_INTERCHANGE) {
            this.enqueueEvent(EDIStreamEvent.START_INTERCHANGE);
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return null;
    }

    private boolean isEvent(int ... eventTypes) {
        return Arrays.stream(eventTypes).anyMatch(this.eventQueue.element()::equals);
    }

    private QName deriveName(QName parent, String hint) {
        String name = hint;
        if (name == null) {
            Location l = this.ediReader.getLocation();
            int componentPosition = l.getComponentPosition();
            name = componentPosition > 0 ? String.format("%s-%d", parent, componentPosition) : String.format("%s%02d", parent, l.getElementPosition());
        }
        return new QName(name);
    }

    private void enqueueEvent(int xmlEvent, QName element, boolean remember) {
        this.eventQueue.add(xmlEvent);
        this.elementQueue.add(element);
        if (remember) {
            this.elementStack.addFirst(element);
        }
    }

    private void advanceEvent() {
        this.eventQueue.remove();
        this.elementQueue.remove();
    }

    private void enqueueEvent(EDIStreamEvent ediEvent) throws XMLStreamException {
        this.cdataBuilder.setLength(0);
        this.cdata = null;
        switch (ediEvent) {
            case ELEMENT_DATA: {
                QName name = this.deriveName(this.elementStack.getFirst(), null);
                this.enqueueEvent(1, name, false);
                this.enqueueEvent(4, DUMMY_QNAME, false);
                this.enqueueEvent(2, name, false);
                break;
            }
            case ELEMENT_DATA_BINARY: {
                QName name = this.deriveName(this.elementStack.getFirst(), null);
                this.enqueueEvent(1, name, false);
                this.enqueueEvent(12, DUMMY_QNAME, false);
                InputStream input = this.ediReader.getBinaryData();
                OutputStream output = Base64.getEncoder().wrap(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        StaEDIXMLStreamReader.this.cdataBuilder.append((char)b);
                    }
                });
                byte[] buffer = new byte[4096];
                try {
                    int amount;
                    while ((amount = input.read(buffer)) > -1) {
                        output.write(buffer, 0, amount);
                    }
                    output.close();
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
                this.enqueueEvent(2, name, false);
                break;
            }
            case START_INTERCHANGE: {
                this.enqueueEvent(7, DUMMY_QNAME, false);
                this.enqueueEvent(1, INTERCHANGE, true);
                break;
            }
            case START_SEGMENT: {
                this.enqueueEvent(1, new QName(this.ediReader.getText()), true);
                break;
            }
            case START_GROUP: 
            case START_TRANSACTION: 
            case START_LOOP: {
                QName name = this.deriveName(this.elementStack.getFirst(), this.ediReader.getText());
                this.enqueueEvent(1, name, true);
                break;
            }
            case START_COMPOSITE: {
                QName name = this.deriveName(this.elementStack.getFirst(), this.ediReader.getReferenceCode());
                this.enqueueEvent(1, name, true);
                break;
            }
            case END_INTERCHANGE: {
                this.enqueueEvent(2, this.elementStack.removeFirst(), false);
                this.enqueueEvent(8, DUMMY_QNAME, false);
                break;
            }
            case END_GROUP: 
            case END_TRANSACTION: 
            case END_LOOP: 
            case END_SEGMENT: 
            case END_COMPOSITE: {
                this.enqueueEvent(2, this.elementStack.removeFirst(), false);
                break;
            }
            case SEGMENT_ERROR: {
                throw new XMLStreamException(String.format("Segment %s has error %s", new Object[]{this.ediReader.getText(), this.ediReader.getErrorType()}));
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)ediEvent));
            }
        }
    }

    private void requireCharacters() {
        if (!this.isCharacters()) {
            throw new IllegalStateException("Text only available for CHARACTERS");
        }
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.eventQueue.isEmpty()) {
            this.advanceEvent();
        }
        if (this.eventQueue.isEmpty()) {
            try {
                this.enqueueEvent(this.ediReader.next());
            }
            catch (EDIStreamException | NoSuchElementException e) {
                throw new XMLStreamException(e);
            }
        }
        return this.getEventType();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        QName name;
        String currentLocalPart;
        int currentType = this.getEventType();
        if (currentType != type) {
            throw new XMLStreamException("Current type " + currentType + " does not match required type " + type);
        }
        if (localName != null && this.hasName() && !localName.equals(currentLocalPart = (name = this.getName()).getLocalPart())) {
            throw new XMLStreamException("Current localPart " + currentLocalPart + " does not match required localName " + localName);
        }
        if (namespaceURI != null) {
            throw new XMLStreamException("Current namespace '' does not match namespaceURI " + namespaceURI);
        }
    }

    static void streamException(String message) throws XMLStreamException {
        throw new XMLStreamException(message);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        int eventType;
        if (this.ediReader.getEventType() != EDIStreamEvent.ELEMENT_DATA) {
            StaEDIXMLStreamReader.streamException("Element text only available for simple element");
        }
        if (this.getEventType() != 1) {
            StaEDIXMLStreamReader.streamException("Element text only available on START_ELEMENT");
        }
        if ((eventType = this.next()) != 4) {
            StaEDIXMLStreamReader.streamException("Unexpected event type: " + eventType);
        }
        String text = this.getText();
        eventType = this.next();
        if (eventType != 2) {
            StaEDIXMLStreamReader.streamException("Unexpected event type after text " + eventType);
        }
        return text;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType;
        while ((eventType = this.next()) != 1 && eventType != 2) {
        }
        return eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        try {
            return this.ediReader.hasNext();
        }
        catch (EDIStreamException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.ediReader.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStartElement() {
        return this.isEvent(1);
    }

    @Override
    public boolean isEndElement() {
        return this.isEvent(2);
    }

    @Override
    public boolean isCharacters() {
        return this.isEvent(4, 12);
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAttributeCount() {
        return 0;
    }

    @Override
    public QName getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeNamespace(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeLocalName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributePrefix(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeType(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNamespaceCount() {
        return 0;
    }

    @Override
    public String getNamespacePrefix(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEventType() {
        return this.eventQueue.isEmpty() ? -1 : this.eventQueue.element();
    }

    @Override
    public String getText() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            if (this.cdata == null) {
                this.cdata = new char[this.cdataBuilder.length()];
                this.cdataBuilder.getChars(0, this.cdataBuilder.length(), this.cdata, 0);
            }
            return new String(this.cdata);
        }
        return this.ediReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            if (this.cdata == null) {
                this.cdata = new char[this.cdataBuilder.length()];
                this.cdataBuilder.getChars(0, this.cdataBuilder.length(), this.cdata, 0);
            }
            return this.cdata;
        }
        return this.ediReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            if (this.cdata == null) {
                this.cdata = new char[this.cdataBuilder.length()];
                this.cdataBuilder.getChars(0, this.cdataBuilder.length(), this.cdata, 0);
            }
            if (targetStart < 0) {
                throw new IndexOutOfBoundsException("targetStart < 0");
            }
            if (targetStart > target.length) {
                throw new IndexOutOfBoundsException("targetStart > target.length");
            }
            if (length < 0) {
                throw new IndexOutOfBoundsException("length < 0");
            }
            if (targetStart + length > target.length) {
                throw new IndexOutOfBoundsException("targetStart + length > target.length");
            }
            System.arraycopy(this.cdata, sourceStart, target, targetStart, length);
            return length;
        }
        return this.ediReader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            return 0;
        }
        return this.ediReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            return this.cdataBuilder.length();
        }
        return this.ediReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.isCharacters();
    }

    @Override
    public javax.xml.stream.Location getLocation() {
        return location;
    }

    @Override
    public QName getName() {
        if (this.hasName()) {
            return this.elementQueue.element();
        }
        throw new IllegalStateException("Text only available for START_ELEMENT or END_ELEMENT");
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public boolean hasName() {
        return this.isStartElement() || this.isEndElement();
    }

    @Override
    public String getNamespaceURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    private static class DefaultLocation
    implements javax.xml.stream.Location {
        private DefaultLocation() {
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    }
}

