/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.function.BiConsumer;

public class UsageError {
    final String code;
    final EDIStreamValidationError error;
    final int depth;

    UsageError(String code, EDIStreamValidationError error, int depth) {
        this.code = code;
        this.error = error;
        this.depth = depth;
    }

    UsageError(EDIStreamValidationError error) {
        this.error = error;
        this.code = null;
        this.depth = -1;
    }

    UsageError(UsageNode node, EDIStreamValidationError error) {
        this.code = node.getCode();
        this.depth = node.getDepth();
        this.error = error;
    }

    void handle(BiConsumer<String, EDIStreamValidationError> handler) {
        handler.accept(this.code, this.error);
    }

    public String getCode() {
        return this.code;
    }

    public EDIStreamValidationError getError() {
        return this.error;
    }

    public int getDepth() {
        return this.depth;
    }
}

