/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.ContentReference;
import io.xlate.edi.internal.stream.json.StaEDIJsonParser;
import io.xlate.edi.stream.EDIStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class StaEDIJacksonJsonParser
extends ParserMinimalBase {
    private static final Version VERSION;
    private static final BigDecimal MIN_LONG;
    private static final BigDecimal MAX_LONG;
    private static final BigDecimal MIN_INTEGER;
    private static final BigDecimal MAX_INTEGER;
    private static final BigDecimal MIN_DOUBLE;
    private static final BigDecimal MAX_DOUBLE;
    private static final BigDecimal MIN_FLOAT;
    private static final BigDecimal MAX_FLOAT;
    private StaEDIJsonParser<JsonParseException> parser;
    private ObjectCodec codec;
    private final Deque<StaEDIJsonStreamContext> context = new ArrayDeque<StaEDIJsonStreamContext>();
    private StaEDIJsonStreamContext pendingContext = null;

    StaEDIJacksonJsonParser(EDIStreamReader ediReader, Map<String, Object> properties) {
        this.parser = new JacksonJsonParser(ediReader, properties);
        this.context.addLast(new StaEDIJsonStreamContext(0, null));
    }

    boolean hasNext() throws IOException {
        return this.parser.hasNext();
    }

    JsonToken next() throws IOException {
        return this.nextToken();
    }

    String getString() throws IOException {
        return this.getText();
    }

    int getInt() {
        return this.getIntValue();
    }

    JsonLocation getLocation() {
        return this.getTokenLocation();
    }

    public JsonToken nextToken() throws IOException {
        JsonToken token;
        if (!this.parser.hasNext()) {
            return null;
        }
        if (this.pendingContext != null) {
            this.context.add(this.pendingContext);
            this.pendingContext = null;
        }
        StaEDIJsonParser.Event next = this.parser.nextEvent();
        switch (next) {
            case END_ARRAY: {
                this.context.removeLast();
                token = JsonToken.END_ARRAY;
                break;
            }
            case END_OBJECT: {
                this.context.removeLast();
                token = JsonToken.END_OBJECT;
                break;
            }
            case KEY_NAME: {
                this.context.getLast().incrementIndex();
                this.context.getLast().setCurrentName(this.getText());
                token = JsonToken.FIELD_NAME;
                break;
            }
            case START_ARRAY: {
                this.context.getLast().incrementIndexIfArray();
                this.pendingContext = new StaEDIJsonStreamContext(1, this.context.getLast());
                token = JsonToken.START_ARRAY;
                break;
            }
            case START_OBJECT: {
                this.context.getLast().incrementIndexIfArray();
                this.pendingContext = new StaEDIJsonStreamContext(2, this.context.getLast());
                token = JsonToken.START_OBJECT;
                break;
            }
            case VALUE_NULL: {
                this.context.getLast().incrementIndexIfArray();
                token = JsonToken.VALUE_NULL;
                break;
            }
            case VALUE_NUMBER: {
                this.context.getLast().incrementIndexIfArray();
                if (this.parser.isIntegralNumber()) {
                    token = JsonToken.VALUE_NUMBER_INT;
                    break;
                }
                token = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case VALUE_STRING: {
                this.context.getLast().incrementIndexIfArray();
                token = JsonToken.VALUE_STRING;
                break;
            }
            default: {
                throw new JsonParseException((JsonParser)this, "Unexpected event reached parsing JSON: " + (Object)((Object)next));
            }
        }
        this._currToken = token;
        return token;
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public String getText() throws IOException {
        return this.parser.getString();
    }

    public char[] getTextCharacters() throws IOException {
        return this.parser.ediReader.getTextCharacters();
    }

    public int getTextLength() throws IOException {
        return this.parser.ediReader.getTextLength();
    }

    public int getTextOffset() throws IOException {
        return this.parser.ediReader.getTextStart();
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this.parser.getBigDecimal().toBigInteger();
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ObjectCodec c) {
        this.codec = c;
    }

    public JsonLocation getCurrentLocation() {
        return this.getTokenLocation();
    }

    public JsonLocation getTokenLocation() {
        return new JacksonJsonLocation(this.parser.getStreamOffset(), this.parser.getLineNumber(), this.parser.getColumnNumber());
    }

    protected void _handleEOF() throws JsonParseException {
    }

    public boolean isClosed() {
        return this.parser.closed;
    }

    public JsonStreamContext getParsingContext() {
        return this.context.getLast().deepCopy();
    }

    public String getCurrentName() throws IOException {
        return this.context.getLast().getCurrentName();
    }

    public void overrideCurrentName(String name) {
    }

    public boolean hasTextCharacters() {
        switch (this.parser.currentEvent) {
            case KEY_NAME: 
            case VALUE_STRING: {
                return true;
            }
        }
        return false;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        return this.parser.currentBinaryValue.toByteArray();
    }

    public Version version() {
        return VERSION;
    }

    static <T extends Number> boolean between(T value, T min, T max) {
        return ((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0;
    }

    public Number getNumberValue() throws IOException {
        Number result;
        if (this.parser.currentEvent != StaEDIJsonParser.Event.VALUE_NUMBER) {
            throw new JsonParseException((JsonParser)this, "Current token is not a number");
        }
        BigDecimal value = this.parser.getBigDecimal();
        switch (this.getNumberType()) {
            case BIG_INTEGER: {
                result = value.toBigInteger();
                break;
            }
            case DOUBLE: {
                result = value.doubleValue();
                break;
            }
            case FLOAT: {
                result = Float.valueOf(value.floatValue());
                break;
            }
            case INT: {
                result = value.intValue();
                break;
            }
            case LONG: {
                result = value.longValue();
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        JsonParser.NumberType type;
        if (this.parser.currentEvent != StaEDIJsonParser.Event.VALUE_NUMBER) {
            return null;
        }
        BigDecimal value = this.parser.getBigDecimal();
        if (value.scale() == 0) {
            type = StaEDIJacksonJsonParser.between(value, MIN_INTEGER, MAX_INTEGER) ? JsonParser.NumberType.INT : (StaEDIJacksonJsonParser.between(value, MIN_LONG, MAX_LONG) ? JsonParser.NumberType.LONG : JsonParser.NumberType.BIG_INTEGER);
        } else {
            int exp = value.precision() - value.scale() - 1;
            type = StaEDIJacksonJsonParser.between(value, MIN_FLOAT, MAX_FLOAT) && StaEDIJacksonJsonParser.between(exp, -126, 127) ? JsonParser.NumberType.FLOAT : (StaEDIJacksonJsonParser.between(value, MIN_DOUBLE, MAX_DOUBLE) && StaEDIJacksonJsonParser.between(exp, -1022, 1023) ? JsonParser.NumberType.DOUBLE : JsonParser.NumberType.BIG_DECIMAL);
        }
        return type;
    }

    public int getIntValue() {
        return this.parser.getInt();
    }

    public long getLongValue() {
        return this.parser.getLong();
    }

    public float getFloatValue() {
        return this.parser.getBigDecimal().floatValue();
    }

    public double getDoubleValue() {
        return this.parser.getBigDecimal().doubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this.parser.getBigDecimal();
    }

    static Version toVersion(Properties projectProperties) {
        String[] version = projectProperties.getProperty("version").split("[.-]");
        return new Version(Integer.parseInt(version[0]), Integer.parseInt(version[1]), Integer.parseInt(version[2]), version.length > 3 ? version[3] : null, projectProperties.getProperty("groupId"), projectProperties.getProperty("artifactId"));
    }

    static {
        MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
        MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
        MIN_INTEGER = BigDecimal.valueOf(Integer.MIN_VALUE);
        MAX_INTEGER = BigDecimal.valueOf(Integer.MAX_VALUE);
        MIN_DOUBLE = BigDecimal.valueOf(-1.7976931348623157E308);
        MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
        MIN_FLOAT = BigDecimal.valueOf(-3.4028234663852886E38);
        MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
        VERSION = Optional.ofNullable(StaEDIJacksonJsonParser.class.getResourceAsStream("/io/xlate/edi/internal/project.properties")).map(stream -> {
            Properties properties;
            block8: {
                InputStream source = stream;
                try {
                    Properties projectProperties = new Properties();
                    projectProperties.load(source);
                    properties = projectProperties;
                    if (source == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                source.close();
            }
            return properties;
        }).map(StaEDIJacksonJsonParser::toVersion).orElseGet(Version::unknownVersion);
    }

    static class StaEDIJsonStreamContext
    extends JsonStreamContext {
        StaEDIJsonStreamContext parent;
        String name;

        StaEDIJsonStreamContext(int type, StaEDIJsonStreamContext parent) {
            super(type, -1);
            this.parent = parent;
        }

        StaEDIJsonStreamContext(StaEDIJsonStreamContext source) {
            super((JsonStreamContext)source);
            this.parent = source.parent != null ? source.parent.deepCopy() : null;
            this.name = source.name;
        }

        void incrementIndexIfArray() {
            if (this.inArray()) {
                this.incrementIndex();
            }
        }

        void incrementIndex() {
            ++this._index;
        }

        public JsonStreamContext getParent() {
            return this.parent;
        }

        public String getCurrentName() {
            return this.name;
        }

        public void setCurrentName(String name) {
            this.name = name;
        }

        public StaEDIJsonStreamContext deepCopy() {
            return new StaEDIJsonStreamContext(this);
        }
    }

    static class JacksonJsonLocation
    extends JsonLocation {
        private static final long serialVersionUID = 1L;

        public JacksonJsonLocation(long streamOffset, long lineNumber, long columnNumber) {
            super(ContentReference.unknown(), streamOffset, (int)lineNumber, (int)columnNumber);
        }

        public long getStreamOffset() {
            return this._totalChars;
        }

        public long getLineNumber() {
            return this._lineNr;
        }

        public long getColumnNumber() {
            return this._columnNr;
        }
    }

    class JacksonJsonParser
    extends StaEDIJsonParser<JsonParseException> {
        JacksonJsonParser(EDIStreamReader ediReader, Map<String, Object> properties) {
            super(ediReader, properties);
        }

        @Override
        protected JsonParseException newJsonException(String message, Throwable cause) {
            return new JsonParseException((JsonParser)StaEDIJacksonJsonParser.this, message, cause);
        }

        @Override
        protected JsonParseException newJsonParsingException(String message, Throwable cause) {
            return this.newJsonException(message, cause);
        }
    }
}

