/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.schema.EDIElementPosition;
import java.util.Objects;

public class ElementPosition
implements EDIElementPosition {
    private static final String TOSTRING_FORMAT = "%d.%d";
    final int elementIndex;
    final int componentIndex;

    public ElementPosition(int elementPosition, int componentPosition) {
        this.elementIndex = elementPosition;
        this.componentIndex = componentPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        ElementPosition other = (ElementPosition)o;
        return Objects.equals(this.elementIndex, other.elementIndex) && Objects.equals(this.componentIndex, other.componentIndex);
    }

    public int hashCode() {
        return Objects.hash(this.elementIndex, this.componentIndex);
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, this.elementIndex, this.componentIndex);
    }

    @Override
    public int getElementPosition() {
        return this.elementIndex;
    }

    @Override
    public int getComponentPosition() {
        return this.componentIndex > 0 ? this.componentIndex : -1;
    }
}

