/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema.implementation;

import io.xlate.edi.internal.schema.implementation.BaseImpl;
import io.xlate.edi.internal.schema.implementation.Positioned;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.implementation.ElementImplementation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ElementImpl
extends BaseImpl<EDISimpleType>
implements ElementImplementation,
Positioned {
    private static final String TOSTRING_FORMAT = "typeId: %s, minOccurs: %d, maxOccurs: %d, position: %d, values: %s, standard: { %s }";
    private final int position;
    private final Map<String, String> values;

    public ElementImpl(int minOccurs, int maxOccurs, String typeId, int position, Map<String, String> values, String title, String description) {
        super(title, description);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.typeId = typeId;
        this.position = position;
        this.values = Collections.unmodifiableMap(new LinkedHashMap<String, String>(values));
    }

    public ElementImpl(EDIReference standardReference, int position) {
        super(null, null);
        this.setStandardReference(standardReference);
        this.typeId = ((EDISimpleType)this.standard).getId();
        this.position = position;
        this.values = ((EDISimpleType)this.standard).getValues();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.position, ((ElementImpl)o).position) && Objects.equals(this.values, ((ElementImpl)o).values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position, this.values);
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, this.typeId, this.minOccurs, this.maxOccurs, this.position, this.values, this.standard);
    }

    @Override
    public Map<String, String> getValues() {
        return this.values;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public EDISimpleType.Base getBase() {
        return ((EDISimpleType)this.standard).getBase();
    }

    @Override
    @Deprecated
    public int getNumber() {
        return ((EDISimpleType)this.standard).getNumber();
    }

    @Override
    public long getMinLength() {
        return ((EDISimpleType)this.standard).getMinLength();
    }

    @Override
    public long getMaxLength() {
        return ((EDISimpleType)this.standard).getMaxLength();
    }
}

