/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.State;
import io.xlate.edi.stream.Location;

public abstract class Dialect {
    protected final String[] transactionVersion;
    protected final int dialectStateCode;
    protected char segmentDelimiter;
    protected char segmentTagTerminator = '\u0000';
    protected char elementDelimiter;
    protected char decimalMark = '\u0000';
    protected char releaseIndicator;
    protected char componentDelimiter;
    protected char elementRepeater;
    protected boolean initialized;
    protected String rejectionMessage;
    protected String transactionType;
    protected String transactionVersionString;

    protected Dialect(int dialectStateCode, String[] initialTransactionVersion) {
        this.dialectStateCode = dialectStateCode;
        this.transactionVersion = initialTransactionVersion;
    }

    public static String getStandard(Dialect dialect) {
        return dialect != null ? dialect.getStandard() : "UNKNOWN";
    }

    public int getDialectStateCode() {
        return this.dialectStateCode;
    }

    public State getTagSearchState() {
        return State.TAG_SEARCH;
    }

    public char getComponentElementSeparator() {
        return this.componentDelimiter;
    }

    public char getDataElementSeparator() {
        return this.elementDelimiter;
    }

    public char getDecimalMark() {
        return this.decimalMark;
    }

    public char getReleaseIndicator() {
        return this.releaseIndicator;
    }

    public char getRepetitionSeparator() {
        return this.elementRepeater;
    }

    public char getSegmentTerminator() {
        return this.segmentDelimiter;
    }

    public char getSegmentTagTerminator() {
        return this.segmentTagTerminator;
    }

    public boolean isDecimalMark(char value) {
        return value == this.getDecimalMark();
    }

    public boolean isConfirmed() {
        return this.initialized;
    }

    public boolean isRejected() {
        return this.rejectionMessage != null;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    public boolean isServiceAdviceSegment(CharSequence segmentTag) {
        return false;
    }

    public abstract String getStandard();

    public abstract String[] getVersion();

    public abstract String getHeaderTag();

    public abstract boolean appendHeader(CharacterSet var1, char var2);

    public abstract void elementData(CharSequence var1, Location var2);

    protected abstract void clearTransactionVersion();

    void updateTransactionVersionString(String[] transactionVersion) {
        this.transactionVersionString = transactionVersion != null ? String.join((CharSequence)".", transactionVersion) : "";
    }

    void setTransactionVersionElement(CharSequence data, int versionElement) {
        this.transactionVersion[versionElement] = data.toString();
        this.updateTransactionVersionString(this.transactionVersion);
    }

    public void transactionEnd() {
        this.transactionType = null;
        this.clearTransactionVersion();
    }

    public void groupEnd() {
        this.clearTransactionVersion();
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String[] getTransactionVersion() {
        return this.transactionVersionString.isEmpty() ? null : this.transactionVersion;
    }

    public String getTransactionVersionString() {
        return this.transactionVersionString;
    }
}

