/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.schema.EDIControlType;
import io.xlate.edi.schema.EDIElementPosition;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.util.List;
import java.util.logging.Logger;

class ControlUsageNode
extends UsageNode {
    static final Logger LOGGER = Logger.getLogger(ControlUsageNode.class.getName());
    String referenceValue;
    EDIControlType type;
    int count;

    ControlUsageNode(UsageNode parent, int depth, EDIReference link, int siblingIndex) {
        super(parent, depth, link, siblingIndex);
        this.type = (EDIControlType)link.getReferencedType();
    }

    @Override
    void reset() {
        super.reset();
        this.referenceValue = null;
        this.count = 0;
    }

    @Override
    void incrementUsage() {
        super.incrementUsage();
        this.referenceValue = null;
        this.count = 0;
    }

    boolean matchesLocation(int segmentRef, EDIElementPosition position, Location location) {
        return position != null && position.matchesLocation(location) && this.type.getReferences().get(segmentRef).getReferencedType().getId().equals(location.getSegmentTag());
    }

    void validateReference(Location location, CharSequence value, List<EDIStreamValidationError> errors) {
        if (this.referenceValue == null) {
            if (this.matchesLocation(0, this.type.getHeaderRefPosition(), location)) {
                this.referenceValue = value.toString();
            }
            return;
        }
        if (this.matchesLocation(this.type.getReferences().size() - 1, this.type.getTrailerRefPosition(), location) && !this.referenceValue.contentEquals(value)) {
            errors.add(EDIStreamValidationError.CONTROL_REFERENCE_MISMATCH);
        }
    }

    void validateCount(Location location, CharSequence value, List<EDIStreamValidationError> errors) {
        if (this.matchesLocation(this.type.getReferences().size() - 1, this.type.getTrailerCountPosition(), location) && !errors.contains((Object)EDIStreamValidationError.INVALID_CHARACTER_DATA) && !String.valueOf(this.count).contentEquals(value)) {
            errors.add(EDIStreamValidationError.CONTROL_COUNT_DOES_NOT_MATCH_ACTUAL_COUNT);
        }
    }

    int incrementCount(EDIControlType.Type countType) {
        if (this.type.getCountType() == countType) {
            ++this.count;
            return this.count;
        }
        return 0;
    }
}

