/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema.implementation;

import io.xlate.edi.internal.schema.implementation.BaseComplexImpl;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.implementation.Discriminator;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.schema.implementation.SegmentImplementation;
import java.util.List;
import java.util.Objects;

public class SegmentImpl
extends BaseComplexImpl
implements SegmentImplementation {
    private static final String TOSTRING_FORMAT = "typeId: %s, code: %s, minOccurs: %d, maxOccurs: %d, discriminator: { %s }, sequence { %s }, standard: { %s }";
    private final String code;
    private final Discriminator discriminator;

    public SegmentImpl(int minOccurs, int maxOccurs, String typeId, String code, Discriminator discriminator, List<EDITypeImplementation> sequence, String title, String description) {
        super(sequence, title, description);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.typeId = typeId;
        this.code = code;
        this.discriminator = discriminator;
    }

    public SegmentImpl(EDIReference standardReference, List<EDITypeImplementation> sequence) {
        super(sequence, null, null);
        this.setStandardReference(standardReference);
        this.code = ((EDIComplexType)this.standard).getCode();
        this.discriminator = null;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.code, ((SegmentImpl)o).code) && Objects.equals(this.discriminator, ((SegmentImpl)o).discriminator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.code, this.discriminator);
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, this.typeId, this.code, this.minOccurs, this.maxOccurs, this.discriminator, this.sequence, this.standard);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Discriminator getDiscriminator() {
        return this.discriminator;
    }
}

