/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.LocationView;
import io.xlate.edi.stream.Location;

public class StaEDIStreamLocation
extends LocationView
implements Location {
    private boolean afterSegment = false;
    private boolean composite = false;
    private boolean repeating = false;
    private int repeatCount = -1;

    public StaEDIStreamLocation() {
    }

    public StaEDIStreamLocation(Location source) {
        super(source);
    }

    public String toString() {
        return super.toString(this.afterSegment);
    }

    @Override
    public StaEDIStreamLocation copy() {
        StaEDIStreamLocation copy = new StaEDIStreamLocation(this);
        copy.afterSegment = this.afterSegment;
        copy.composite = this.composite;
        copy.repeating = this.repeating;
        copy.repeatCount = this.repeatCount;
        return copy;
    }

    public void set(StaEDIStreamLocation source) {
        this.lineNumber = source.getLineNumber();
        this.columnNumber = source.getColumnNumber();
        this.characterOffset = source.getCharacterOffset();
        this.segmentPosition = source.getSegmentPosition();
        this.segmentTag = source.getSegmentTag();
        this.elementPosition = source.getElementPosition();
        this.componentPosition = source.getComponentPosition();
        this.elementOccurrence = source.getElementOccurrence();
        this.afterSegment = source.afterSegment;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public void setElementOccurrence(int elementOccurrence) {
        this.elementOccurrence = elementOccurrence;
    }

    public void setComponentPosition(int componentPosition) {
        this.componentPosition = componentPosition;
    }

    public void incrementOffset(int value) {
        ++this.characterOffset;
        if (value == 10) {
            ++this.lineNumber;
            this.columnNumber = 0;
        }
        ++this.columnNumber;
    }

    static int initOrIncrement(int position) {
        if (position < 0) {
            return 1;
        }
        return position + 1;
    }

    public void incrementSegmentPosition(String segmentTag) {
        this.segmentPosition = StaEDIStreamLocation.initOrIncrement(this.segmentPosition);
        this.segmentTag = segmentTag;
        this.clearSegmentLocations(false);
    }

    public void clearSegmentLocations(boolean afterSegment) {
        this.afterSegment = afterSegment;
        this.elementPosition = -1;
        this.elementOccurrence = -1;
        this.repeating = false;
        this.repeatCount = -1;
        this.clearComponentPosition();
    }

    public void incrementElementPosition() {
        this.elementPosition = StaEDIStreamLocation.initOrIncrement(this.elementPosition);
        this.elementOccurrence = 1;
        this.clearComponentPosition();
    }

    public void incrementElementOccurrence() {
        this.elementPosition = Math.max(this.elementPosition, 1);
        this.elementOccurrence = StaEDIStreamLocation.initOrIncrement(this.elementOccurrence);
        this.clearComponentPosition();
    }

    public void incrementComponentPosition() {
        this.componentPosition = StaEDIStreamLocation.initOrIncrement(this.componentPosition);
    }

    public void clearComponentPosition() {
        this.composite = false;
        this.componentPosition = -1;
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public void setRepeating(boolean repeating) {
        this.repeatCount = repeating ? (this.repeating ? ++this.repeatCount : 0) : (this.repeating ? ++this.repeatCount : -1);
        this.repeating = repeating;
    }

    public void incrementElement(boolean compositeBegin) {
        if (this.composite) {
            this.incrementComponentPosition();
        } else if (this.elementPosition < 0 || this.repeatCount == -1) {
            this.incrementElementPosition();
        } else if (this.repeating) {
            if (compositeBegin) {
                this.incrementElementOccurrence();
            } else if (this.repeatCount == 0) {
                this.incrementElementPosition();
            } else {
                this.incrementElementOccurrence();
            }
        } else if (compositeBegin) {
            this.incrementElementPosition();
        } else {
            this.incrementElementOccurrence();
        }
    }
}

