/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.json;

import io.xlate.edi.internal.stream.Configurable;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamReader;
import io.xlate.edi.stream.EDIValidationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayDeque;
import java.util.Base64;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class StaEDIJsonParser<E extends Exception>
implements Configurable {
    private static final Logger LOGGER = Logger.getLogger(StaEDIJsonParser.class.getName());
    static final String MSG_EXCEPTION = "Exception reading the EDI stream as JSON";
    static final String MSG_UNEXPECTED = "Unexpected event reached parsing JSON: ";
    static final String KEY_TYPE = "type";
    static final String KEY_NAME = "name";
    static final String KEY_META = "meta";
    static final String KEY_DATA = "data";
    protected final EDIStreamReader ediReader;
    protected final Map<String, Object> properties;
    protected final boolean emptyElementsNull;
    protected final boolean elementsAsObject;
    final Queue<Event> eventQueue = new ArrayDeque<Event>();
    final Queue<String> valueQueue = new ArrayDeque<String>();
    final DecimalFormat decimalParser = new DecimalFormat();
    final ParsePosition decimalPosition = new ParsePosition(0);
    Event currentEvent;
    String currentValue;
    ByteArrayOutputStream currentBinaryValue = new ByteArrayOutputStream();
    BigDecimal currentNumber;
    boolean closed = false;

    StaEDIJsonParser(EDIStreamReader ediReader, Map<String, Object> properties) {
        this.ediReader = ediReader;
        this.properties = properties;
        this.emptyElementsNull = this.getProperty("io.xlate.edi.stream.JSON_NULL_EMPTY_ELEMENTS", Boolean::parseBoolean, false);
        this.elementsAsObject = this.getProperty("io.xlate.edi.stream.JSON_OBJECT_ELEMENTS", Boolean::parseBoolean, false);
    }

    static <E extends Enum<E>> E[] mapEvents(Class<E> eventType) {
        Map<String, Integer> ordinals = Stream.of(Event.values()).collect(Collectors.toMap(Enum::name, Enum::ordinal));
        ToIntFunction<Enum> ordinal = e -> (Integer)ordinals.get(e.name());
        return (Enum[])Stream.of((Enum[])eventType.getEnumConstants()).filter(c -> ordinals.containsKey(c.name())).sorted((c1, c2) -> Integer.compare(ordinal.applyAsInt((Enum)c1), ordinal.applyAsInt((Enum)c2))).map(eventType::cast).toArray(size -> (Enum[])Array.newInstance(eventType, size));
    }

    protected abstract E newJsonException(String var1, Throwable var2);

    protected abstract E newJsonParsingException(String var1, Throwable var2);

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    <T> T executeWithReader(Callable<T> runner) throws E {
        try {
            return runner.call();
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw this.newJsonException(MSG_EXCEPTION, e);
            }
            throw this.newJsonParsingException(MSG_EXCEPTION, e);
        }
    }

    void advanceEvent() {
        this.currentEvent = this.eventQueue.remove();
        this.currentValue = this.valueQueue.remove();
    }

    void parseNumber(EDISimpleType elementType, String text) {
        if (elementType.getBase() == EDISimpleType.Base.NUMERIC) {
            Integer scale = elementType.getScale();
            try {
                long unscaled = Long.parseLong(text);
                this.currentNumber = BigDecimal.valueOf(unscaled, scale);
            }
            catch (NumberFormatException e) {
                BigInteger unscaled = new BigInteger(text);
                this.currentNumber = new BigDecimal(unscaled, scale);
            }
        } else {
            this.decimalPosition.setIndex(0);
            this.decimalParser.setParseBigDecimal(true);
            this.currentNumber = (BigDecimal)this.decimalParser.parse(text, this.decimalPosition);
        }
    }

    void enqueue(Event event, String value) {
        this.eventQueue.add(event);
        this.valueQueue.add(value != null ? value : "");
    }

    void enqueueStructureBegin(String typeName, String structureName) {
        this.enqueue(Event.START_OBJECT, null);
        this.enqueue(Event.KEY_NAME, KEY_NAME);
        this.enqueue(Event.VALUE_STRING, structureName);
        this.enqueue(Event.KEY_NAME, KEY_TYPE);
        this.enqueue(Event.VALUE_STRING, typeName);
        this.enqueue(Event.KEY_NAME, KEY_DATA);
        this.enqueue(Event.START_ARRAY, null);
    }

    void readBinaryValue() throws E {
        try (InputStream binaryStream = this.ediReader.getBinaryData();){
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = binaryStream.read(buffer)) > -1) {
                this.currentBinaryValue.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw this.newJsonException(MSG_EXCEPTION, e);
        }
    }

    boolean isNumber(EDISimpleType elementType) {
        return elementType.getBase() == EDISimpleType.Base.DECIMAL || elementType.getBase() == EDISimpleType.Base.NUMERIC;
    }

    void enqueueDataElement(boolean binaryData) throws E {
        Event dataEvent;
        String dataText;
        EDIReference referencedType = this.ediReader.getSchemaTypeReference();
        EDISimpleType elementType = null;
        if (referencedType != null) {
            elementType = (EDISimpleType)referencedType.getReferencedType();
        }
        if (this.elementsAsObject) {
            this.enqueue(Event.START_OBJECT, null);
            this.enqueue(Event.KEY_NAME, KEY_TYPE);
            this.enqueue(Event.VALUE_STRING, "element");
            this.enqueue(Event.KEY_NAME, KEY_DATA);
        }
        String string = dataText = this.ediReader.hasText() ? this.ediReader.getText() : "";
        if (elementType == null) {
            dataEvent = Event.VALUE_STRING;
        } else if (binaryData) {
            this.readBinaryValue();
            dataEvent = Event.VALUE_STRING;
        } else if (dataText.isEmpty()) {
            dataEvent = this.emptyElementsNull ? Event.VALUE_NULL : Event.VALUE_STRING;
        } else if (this.isNumber(elementType)) {
            Event numberEvent;
            try {
                this.parseNumber(elementType, dataText);
                numberEvent = Event.VALUE_NUMBER;
            }
            catch (Exception e) {
                numberEvent = Event.VALUE_STRING;
            }
            dataEvent = numberEvent;
        } else {
            dataEvent = Event.VALUE_STRING;
        }
        this.enqueue(dataEvent, dataText);
        if (this.elementsAsObject) {
            this.enqueue(Event.END_OBJECT, null);
        }
    }

    void enqueueEvent(EDIStreamEvent ediEvent) throws E {
        LOGGER.finer(() -> "Enqueue EDI event: " + (Object)((Object)ediEvent));
        this.currentNumber = null;
        this.currentValue = null;
        this.currentBinaryValue.reset();
        switch (ediEvent) {
            case ELEMENT_DATA: {
                this.enqueueDataElement(false);
                break;
            }
            case ELEMENT_DATA_BINARY: {
                this.enqueueDataElement(true);
                break;
            }
            case START_INTERCHANGE: {
                this.enqueueStructureBegin("loop", "INTERCHANGE");
                break;
            }
            case START_GROUP: 
            case START_TRANSACTION: 
            case START_LOOP: {
                this.enqueueStructureBegin("loop", this.ediReader.getReferenceCode());
                break;
            }
            case START_SEGMENT: {
                this.enqueueStructureBegin("segment", this.ediReader.getText());
                break;
            }
            case START_COMPOSITE: {
                this.enqueueStructureBegin("composite", this.ediReader.getReferenceCode());
                break;
            }
            case END_INTERCHANGE: 
            case END_GROUP: 
            case END_TRANSACTION: 
            case END_LOOP: 
            case END_SEGMENT: 
            case END_COMPOSITE: {
                this.enqueue(Event.END_ARRAY, null);
                this.enqueue(Event.END_OBJECT, null);
                break;
            }
            case SEGMENT_ERROR: 
            case ELEMENT_OCCURRENCE_ERROR: 
            case ELEMENT_DATA_ERROR: {
                EDIValidationException cause = new EDIValidationException(ediEvent, this.ediReader.getErrorType(), this.ediReader.getLocation(), this.ediReader.getText());
                throw this.newJsonParsingException("Unhandled EDI validation error", cause);
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)ediEvent));
            }
        }
    }

    Event nextEvent() throws E {
        if (this.eventQueue.isEmpty()) {
            LOGGER.finer(() -> "eventQueue is empty, calling ediReader.next()");
            this.enqueueEvent(this.executeWithReader(this.ediReader::next));
        }
        this.advanceEvent();
        return this.currentEvent;
    }

    public long getLineNumber() {
        return this.ediReader.getLocation().getLineNumber();
    }

    public long getColumnNumber() {
        return this.ediReader.getLocation().getColumnNumber();
    }

    public long getStreamOffset() {
        return this.ediReader.getLocation().getCharacterOffset();
    }

    public void close() throws E {
        try {
            this.ediReader.close();
        }
        catch (IOException e) {
            throw this.newJsonException(MSG_EXCEPTION, e);
        }
        finally {
            this.closed = true;
        }
    }

    void assertEventSet(String message) {
        if (this.currentEvent == null) {
            throw new IllegalStateException(message);
        }
    }

    void assertEvent(Event required, Function<Event, String> message) {
        Event current = this.currentEvent;
        if (current != required) {
            throw new IllegalStateException(message.apply(current));
        }
    }

    void assertEventValueNumber() {
        this.assertEvent(Event.VALUE_NUMBER, current -> "Unable to get number value for event [" + (Object)current + ']');
    }

    void assertEventValueString() {
        Event current = this.currentEvent;
        switch (current) {
            case KEY_NAME: 
            case VALUE_STRING: 
            case VALUE_NUMBER: {
                break;
            }
            default: {
                throw new IllegalStateException("Unable to get string value for event [" + (Object)((Object)current) + ']');
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasNext() throws E {
        if (!this.eventQueue.isEmpty()) return true;
        if (this.executeWithReader(this.ediReader::hasNext) == false) return false;
        return true;
    }

    public BigDecimal getBigDecimal() {
        this.assertEventValueNumber();
        return this.currentNumber;
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        this.assertEventValueNumber();
        return this.currentNumber.longValue();
    }

    public String getString() {
        this.assertEventValueString();
        if (this.currentBinaryValue.size() > 0) {
            return Base64.getEncoder().encodeToString(this.currentBinaryValue.toByteArray());
        }
        return this.currentValue;
    }

    public boolean isIntegralNumber() {
        this.assertEventValueNumber();
        return this.currentNumber.scale() == 0;
    }

    static enum Event {
        START_ARRAY,
        START_OBJECT,
        KEY_NAME,
        VALUE_STRING,
        VALUE_NUMBER,
        VALUE_NULL,
        END_OBJECT,
        END_ARRAY;

    }
}

