/*******************************************************************************
 * Copyright 2017 xlate.io LLC, http://www.xlate.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 ******************************************************************************/
package io.xlate.edi.internal.schema;

import java.util.Objects;

import io.xlate.edi.schema.EDIType;

abstract class BasicType implements EDIType {

    private final String id;
    private final Type type;
    private final String title;
    private final String description;

    BasicType(String id, Type type, String title, String description) {
        Objects.requireNonNull(id, "EDIType id must not be null");
        Objects.requireNonNull(type, "EDIType type must not be null");
        this.id = id;
        this.type = type;
        this.title = title;
        this.description = description;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BasicType) {
            BasicType other = (BasicType) o;
            return Objects.equals(id, other.id) && Objects.equals(type, other.type);
        }

        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type);
    }
}
