/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.ThrowingRunnable;
import io.xlate.edi.internal.schema.SchemaUtils;
import io.xlate.edi.internal.stream.Configurable;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.Lexer;
import io.xlate.edi.internal.stream.tokenization.ProxyEventHandler;
import io.xlate.edi.internal.stream.validation.ValidatorConfig;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIInputErrorReporter;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamReader;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class StaEDIStreamReader
implements EDIStreamReader,
Configurable,
ValidatorConfig {
    private static final Logger LOGGER = Logger.getLogger(StaEDIStreamReader.class.getName());
    private static final CharBuffer GROUP_TEXT = CharBuffer.wrap(ProxyEventHandler.LOOP_CODE_GROUP);
    private static final CharBuffer TRANSACTION_TEXT = CharBuffer.wrap(ProxyEventHandler.LOOP_CODE_TRANSACTION);
    private Schema controlSchema;
    private final Map<String, Object> properties;
    private final EDIInputErrorReporter reporter;
    private final StaEDIStreamLocation location = new StaEDIStreamLocation();
    private final ProxyEventHandler proxy;
    private final Lexer lexer;
    private boolean complete = false;
    private boolean closed = false;
    private boolean deprecationLogged = false;

    public StaEDIStreamReader(InputStream stream, Charset charset, Schema schema, Map<String, Object> properties, EDIInputErrorReporter reporter) {
        this.controlSchema = schema;
        this.properties = new HashMap<String, Object>(properties);
        this.reporter = reporter;
        this.proxy = new ProxyEventHandler(this.location, this.controlSchema, this.nestHierarchicalLoops(), this);
        this.lexer = new Lexer(stream, charset, this.proxy, this.location, this.ignoreExtraneousCharacters());
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed");
        }
    }

    private void ensureIncomplete() {
        if (this.complete) {
            throw new NoSuchElementException("Reader is complete");
        }
    }

    void ensureValueAvailable(Function<Dialect, Object> valueSupplier, String valueType) {
        if (this.lexer.getDialect() == null || valueSupplier.apply(this.lexer.getDialect()) == null) {
            throw new IllegalStateException(valueType + " not accessible");
        }
    }

    void requireEvent(String message, EDIStreamEvent ... events) {
        EDIStreamEvent current = this.proxy.getEvent();
        for (EDIStreamEvent e : events) {
            if (current != e) continue;
            return;
        }
        throw new IllegalStateException(message);
    }

    private void logDeprecation(EDIStreamEvent event) {
        if (!this.deprecationLogged) {
            this.deprecationLogged = true;
            LOGGER.warning(() -> "DEPRECATION - Retrieving text for event " + (Object)((Object)event) + " will not be supported in a future release. Use `getReferenceCode` or `getSchemaTypeReference` to retrieve additional information for non-textual event types.");
        }
    }

    private CharBuffer getBuffer() {
        this.checkTextState();
        EDIStreamEvent event = this.getEventType();
        switch (event) {
            case START_GROUP: 
            case END_GROUP: {
                this.logDeprecation(event);
                return GROUP_TEXT;
            }
            case START_TRANSACTION: 
            case END_TRANSACTION: {
                this.logDeprecation(event);
                return TRANSACTION_TEXT;
            }
            case START_LOOP: 
            case END_LOOP: {
                this.logDeprecation(event);
                return CharBuffer.wrap(this.proxy.getSchemaTypeReference().getReferencedType().getCode());
            }
        }
        return this.proxy.getCharacters();
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        return this.properties.get(name);
    }

    @Override
    public Map<String, Character> getDelimiters() {
        Dialect dialect = this.lexer.getDialect();
        if (dialect == null) {
            throw new IllegalStateException("getDelimiters must be called within an interchange");
        }
        HashMap<String, Character> delimiters = new HashMap<String, Character>(5);
        delimiters.put("io.xlate.edi.stream.delim.segment", Character.valueOf(dialect.getSegmentTerminator()));
        delimiters.put("io.xlate.edi.stream.delim.dataElement", Character.valueOf(dialect.getDataElementSeparator()));
        delimiters.put("io.xlate.edi.stream.delim.componentElement", Character.valueOf(dialect.getComponentElementSeparator()));
        if (dialect.getDecimalMark() != '\u0000') {
            delimiters.put("io.xlate.edi.stream.delim.decimal", Character.valueOf(dialect.getDecimalMark()));
        }
        if (dialect.getRepetitionSeparator() != '\u0000') {
            delimiters.put("io.xlate.edi.stream.delim.repetition", Character.valueOf(dialect.getRepetitionSeparator()));
        }
        if (dialect.getReleaseIndicator() != '\u0000') {
            delimiters.put("io.xlate.edi.stream.delim.release", Character.valueOf(dialect.getReleaseIndicator()));
        }
        return Collections.unmodifiableMap(delimiters);
    }

    void executeTask(ThrowingRunnable<Exception> task, String errorMessage) throws EDIStreamException {
        ThrowingRunnable.run(task, e -> {
            if (e instanceof EDIStreamException) {
                return (EDIStreamException)e;
            }
            Location where = this.getLocation();
            return new EDIStreamException(errorMessage, where, (Throwable)e);
        });
    }

    private EDIStreamEvent nextEvent() throws EDIStreamException {
        this.ensureOpen();
        this.ensureIncomplete();
        if (EDIStreamEvent.START_INTERCHANGE == this.proxy.getEvent() && this.useInternalControlSchema()) {
            try {
                LOGGER.finer(() -> "Setting control schema: " + this.getStandard() + ", " + this.getVersion());
                this.setControlSchema(SchemaUtils.getControlSchema(this.getStandard(), this.getVersion()));
                LOGGER.finer(() -> "Done setting control schema: " + this.getStandard() + ", " + this.getVersion());
            }
            catch (EDISchemaException e) {
                LOGGER.log(Level.WARNING, String.format("Exception loading controlSchema for standard %s, version %s: %s", this.getStandard(), Arrays.stream(this.getVersion()).map(Object::toString).collect(Collectors.joining(", ")), e.getMessage()), e);
            }
        }
        if (!this.proxy.nextEvent()) {
            this.proxy.resetEvents();
            this.executeTask(this.lexer::parse, "Error parsing input");
        }
        EDIStreamEvent event = this.proxy.getEvent();
        LOGGER.finer(() -> "EDI event: " + (Object)((Object)event));
        if (event == EDIStreamEvent.END_INTERCHANGE) {
            this.executeTask(() -> {
                this.complete = !this.proxy.hasNext() && !this.lexer.hasRemaining();
            }, "Error reading input");
        }
        if (event == EDIStreamEvent.ELEMENT_DATA && this.proxy.isBinaryElementLength()) {
            try {
                this.setBinaryDataLength(Long.parseLong(this.getText()));
            }
            catch (NumberFormatException e) {
                this.lexer.invalidate();
                throw new EDIStreamException("Failed to parse binary element length", this.location, e);
            }
        }
        return event;
    }

    @Override
    public EDIStreamEvent next() throws EDIStreamException {
        EDIStreamEvent event = null;
        boolean eventFound = false;
        do {
            event = this.nextEvent();
            if (this.reporter != null && event.isError()) {
                this.reporter.report(this.getErrorType(), this);
                continue;
            }
            eventFound = true;
        } while (!this.complete && !eventFound);
        return event;
    }

    @Override
    public EDIStreamEvent nextTag() throws EDIStreamException {
        EDIStreamEvent event = null;
        boolean tagFound = false;
        do {
            event = this.next();
            switch (event) {
                case START_GROUP: 
                case START_TRANSACTION: 
                case START_LOOP: 
                case START_SEGMENT: {
                    tagFound = true;
                    break;
                }
            }
        } while (!this.complete && !tagFound);
        if (!tagFound) {
            throw new NoSuchElementException("No additional tags in stream");
        }
        return event;
    }

    @Override
    public boolean hasNext() throws EDIStreamException {
        this.ensureOpen();
        return !this.complete;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public EDIStreamEvent getEventType() {
        this.ensureOpen();
        return this.proxy.getEvent();
    }

    @Override
    public String getStandard() {
        if (this.lexer.getDialect() == null) {
            throw new IllegalStateException("standard not accessible");
        }
        return this.lexer.getDialect().getStandard();
    }

    @Override
    public String[] getVersion() {
        this.ensureValueAvailable(Dialect::getVersion, "version");
        String[] version = this.lexer.getDialect().getVersion();
        return Arrays.copyOf(version, version.length);
    }

    @Override
    public String[] getTransactionVersion() {
        this.ensureValueAvailable(Dialect::getTransactionVersion, "transaction version");
        String[] version = this.lexer.getDialect().getTransactionVersion();
        return Arrays.copyOf(version, version.length);
    }

    @Override
    public String getTransactionVersionString() {
        this.ensureValueAvailable(Dialect::getTransactionVersion, "transaction version");
        return this.lexer.getDialect().getTransactionVersionString();
    }

    @Override
    public String getTransactionType() {
        this.ensureValueAvailable(Dialect::getTransactionType, "transaction type");
        return this.lexer.getDialect().getTransactionType();
    }

    @Override
    public Schema getControlSchema() {
        return this.controlSchema;
    }

    @Override
    public void setControlSchema(Schema schema) {
        if (this.getEventType() != EDIStreamEvent.START_INTERCHANGE) {
            throw new IllegalStateException("control schema set after interchange start");
        }
        if (this.controlSchema != null) {
            throw new IllegalStateException("control schema already set");
        }
        this.controlSchema = schema;
        this.proxy.setControlSchema(schema);
    }

    @Override
    public Schema getTransactionSchema() {
        return this.proxy.getTransactionSchema();
    }

    @Override
    public void setTransactionSchema(Schema schema) {
        if (!this.proxy.isTransactionSchemaAllowed()) {
            throw new IllegalStateException("Transaction schema can only be set during transaction start");
        }
        this.proxy.setTransactionSchema(schema);
    }

    @Override
    public String getReferenceCode() {
        return this.proxy.getReferenceCode();
    }

    @Override
    public EDIStreamValidationError getErrorType() {
        this.requireEvent("not a valid error state", EDIStreamEvent.ELEMENT_DATA_ERROR, EDIStreamEvent.ELEMENT_OCCURRENCE_ERROR, EDIStreamEvent.SEGMENT_ERROR);
        return this.proxy.getErrorType();
    }

    private void checkTextState() {
        if (!this.hasText()) {
            throw new IllegalStateException("not a valid text state [" + (Object)((Object)this.getEventType()) + ']');
        }
    }

    @Override
    public boolean hasText() {
        EDIStreamEvent event = this.getEventType();
        if (event == null) {
            return false;
        }
        switch (event) {
            case START_SEGMENT: 
            case END_SEGMENT: 
            case ELEMENT_DATA: 
            case ELEMENT_DATA_ERROR: 
            case ELEMENT_OCCURRENCE_ERROR: 
            case SEGMENT_ERROR: {
                return true;
            }
            case START_GROUP: 
            case END_GROUP: 
            case START_TRANSACTION: 
            case END_TRANSACTION: 
            case START_LOOP: 
            case END_LOOP: {
                return this.enableLoopText();
            }
        }
        return false;
    }

    @Override
    public String getText() {
        CharBuffer buffer = this.getBuffer();
        return buffer.toString();
    }

    @Override
    public char[] getTextCharacters() {
        CharBuffer buffer = this.getBuffer();
        return Arrays.copyOf(buffer.array(), buffer.length());
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) {
        if (target == null) {
            throw new NullPointerException("Null target array");
        }
        if (targetStart < 0) {
            throw new IndexOutOfBoundsException("targetStart < 0");
        }
        if (targetStart > target.length) {
            throw new IndexOutOfBoundsException("targetStart > target.length");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length < 0");
        }
        if (length > target.length) {
            throw new IndexOutOfBoundsException("length (" + length + ") > target.length (" + target.length + ")");
        }
        CharBuffer buffer = this.getBuffer();
        char[] contents = buffer.array();
        int count = buffer.remaining();
        if (sourceStart < 0) {
            throw new IndexOutOfBoundsException("sourceStart < 0");
        }
        if (sourceStart > count) {
            throw new IndexOutOfBoundsException("sourceStart > source length");
        }
        int toCopy = Math.min(count - sourceStart, length);
        System.arraycopy(contents, sourceStart, target, targetStart, toCopy);
        return toCopy;
    }

    @Override
    public int getTextStart() {
        CharBuffer buffer = this.getBuffer();
        return buffer.position();
    }

    @Override
    public int getTextLength() {
        CharBuffer buffer = this.getBuffer();
        return buffer.limit();
    }

    @Override
    public Location getLocation() {
        this.ensureOpen();
        return this.proxy.getLocation();
    }

    @Override
    public void setBinaryDataLength(long length) throws EDIStreamException {
        this.ensureOpen();
        this.requireEvent("invalid state for setting binary length", EDIStreamEvent.START_SEGMENT, EDIStreamEvent.ELEMENT_DATA, EDIStreamEvent.END_COMPOSITE);
        this.lexer.setBinaryLength(length);
    }

    @Override
    public InputStream getBinaryData() {
        this.ensureOpen();
        this.requireEvent("not binary data element", EDIStreamEvent.ELEMENT_DATA_BINARY);
        return this.proxy.getBinary();
    }

    @Override
    public EDIReference getSchemaTypeReference() {
        return this.proxy.getSchemaTypeReference();
    }

    @Override
    public boolean validateControlCodeValues() {
        return this.getProperty("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_CODE_VALUES", Boolean::parseBoolean, true);
    }

    boolean useInternalControlSchema() {
        if (this.controlSchema != null) {
            return false;
        }
        return this.getProperty("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_STRUCTURE", Boolean::parseBoolean, true);
    }

    boolean ignoreExtraneousCharacters() {
        return this.getProperty("io.xlate.edi.stream.EDI_IGNORE_EXTRANEOUS_CHARACTERS", Boolean::parseBoolean, false);
    }

    boolean nestHierarchicalLoops() {
        return this.getProperty("io.xlate.edi.stream.EDI_NEST_HIERARCHICAL_LOOPS", Boolean::parseBoolean, true);
    }

    boolean enableLoopText() {
        return this.getProperty("io.xlate.edi.stream.EDI_ENABLE_LOOP_TEXT", Boolean::parseBoolean, true);
    }

    @Override
    public boolean trimDiscriminatorValues() {
        return this.getProperty("io.xlate.edi.stream.EDI_TRIM_DISCRIMINATOR_VALUES", Boolean::parseBoolean, false);
    }

    @Override
    public boolean formatElements() {
        return false;
    }
}

