/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.DialectFactory;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.tokenization.EventHandler;
import io.xlate.edi.internal.stream.tokenization.State;
import io.xlate.edi.stream.Location;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.IntSupplier;
import java.util.logging.Logger;

public class Lexer {
    private static final Logger LOGGER = Logger.getLogger(Lexer.class.getName());
    private final Deque<Mode> modes = new ArrayDeque<Mode>();
    private State state = State.INITIAL;
    private int previousInput = 0;
    private State previous;
    private final Deque<Notifier> events = new ArrayDeque<Notifier>(20);
    private final Deque<State> stateQueue = new ArrayDeque<State>(20);
    private final Deque<Integer> startQueue = new ArrayDeque<Integer>(20);
    private final Deque<Integer> lengthQueue = new ArrayDeque<Integer>(20);
    private final InputStream stream;
    private CharsetDecoder decoder;
    private char[] readChar = new char[1];
    private CharBuffer readCharBuf = CharBuffer.wrap(this.readChar);
    private ByteBuffer readByteBuf = ByteBuffer.allocate(4);
    private CharArraySequence elementHolder = new CharArraySequence();
    private final StaEDIStreamLocation location;
    private final CharacterSet characters;
    private CharBuffer buffer = CharBuffer.allocate(4096);
    private Dialect dialect;
    private long binaryRemain = -1L;
    private InputStream binaryStream = null;
    private Notifier isn;
    private Notifier ien;
    private Notifier ssn;
    private Notifier sen;
    private Notifier csn;
    private Notifier cen;
    private Notifier en;
    private Notifier bn;

    public Lexer(InputStream stream, Charset charset, EventHandler handler, StaEDIStreamLocation location, boolean extraneousIgnored) {
        this.stream = stream.markSupported() ? stream : new BufferedInputStream(stream);
        this.decoder = charset.newDecoder();
        this.location = location;
        this.characters = new CharacterSet(extraneousIgnored);
        this.isn = (notifyState, start, length) -> {
            handler.interchangeBegin(this.dialect);
            return true;
        };
        this.ien = (notifyState, start, length) -> {
            handler.interchangeEnd();
            this.dialect = null;
            this.characters.reset();
            return true;
        };
        this.ssn = (notifyState, start, length) -> {
            String segmentTag = new String(this.buffer.array(), start, length);
            return handler.segmentBegin(segmentTag);
        };
        this.sen = (notifyState, start, length) -> handler.segmentEnd();
        this.csn = (notifyState, start, length) -> handler.compositeBegin(false, false);
        this.cen = (notifyState, start, length) -> handler.compositeEnd(false);
        this.bn = (notifyState, start, length) -> handler.binaryData(this.binaryStream);
        this.en = (notifyState, start, length) -> {
            this.elementHolder.set(this.buffer.array(), start, length);
            return handler.elementData(this.elementHolder, true);
        };
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void invalidate() {
        if (this.state != State.INVALID) {
            this.previous = this.state;
            this.state = State.INVALID;
        }
    }

    public void setBinaryLength(long binaryLength) {
        this.binaryRemain = binaryLength;
        this.binaryStream = new InputStream(){

            @Override
            public int read() throws IOException {
                int binaryInput = -1;
                if (Lexer.this.binaryRemain-- < 1L || (binaryInput = Lexer.this.stream.read()) < 0) {
                    Lexer.this.state = State.ELEMENT_END_BINARY;
                } else {
                    Lexer.this.location.incrementOffset(binaryInput);
                }
                return binaryInput;
            }
        };
        this.enqueue(this.bn, 0);
        this.state = State.ELEMENT_DATA_BINARY;
    }

    public boolean hasRemaining() throws IOException {
        int peekInput;
        this.stream.mark(200);
        boolean spaceOnly = true;
        while ((peekInput = this.stream.read()) > -1 && spaceOnly) {
            spaceOnly = this.characters.isWhitespace(peekInput);
        }
        this.stream.reset();
        return !spaceOnly;
    }

    public void parse() throws IOException, EDIException {
        try {
            this.parse(this::readCharacterUnchecked);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    void parse(IntSupplier inputSource) throws EDIException {
        if (this.nextEvent()) {
            return;
        }
        if (this.state.isInvalid()) {
            throw this.invalidStateError(this.previousInput, this.state, this.previous);
        }
        int input = 0;
        boolean eventsReady = false;
        while (!eventsReady && (input = inputSource.getAsInt()) > -1) {
            eventsReady = this.processInputCharacter(input);
        }
        if (input < 0) {
            throw this.error(EDIException.INCOMPLETE_STREAM);
        }
    }

    boolean processInputCharacter(int input) throws EDIException {
        boolean eventsReady = false;
        this.location.incrementOffset(input);
        CharacterClass clazz = this.characters.getClass(input);
        this.previous = this.state;
        this.previousInput = input;
        this.state = State.transition(this.state, this.dialect, clazz);
        LOGGER.finer(() -> String.format("%s + (%s, '%s', %s) -> %s", new Object[]{this.previous, Dialect.getStandard(this.dialect), Character.valueOf((char)input), clazz, this.state}));
        switch (this.state) {
            case INITIAL: 
            case TAG_SEARCH: 
            case HEADER_EDIFACT_UNB_SEARCH: {
                break;
            }
            case HEADER_X12_I: 
            case HEADER_X12_S: 
            case HEADER_EDIFACT_N: 
            case HEADER_EDIFACT_U: 
            case HEADER_TRADACOMS_S: 
            case HEADER_TRADACOMS_T: 
            case TAG_1: 
            case TAG_2: 
            case TAG_3: 
            case TRAILER_X12_I: 
            case TRAILER_X12_E: 
            case TRAILER_X12_A: 
            case TRAILER_EDIFACT_U: 
            case TRAILER_EDIFACT_N: 
            case TRAILER_EDIFACT_Z: 
            case TRAILER_TRADACOMS_E: 
            case TRAILER_TRADACOMS_N: 
            case TRAILER_TRADACOMS_D: 
            case ELEMENT_DATA: 
            case TRAILER_ELEMENT_DATA: {
                this.buffer.put((char)input);
                break;
            }
            case ELEMENT_INVALID_DATA: {
                if (this.characters.isIgnored(input)) break;
                this.buffer.put((char)input);
                break;
            }
            case HEADER_EDIFACT_UNB_1: 
            case HEADER_EDIFACT_UNB_2: 
            case HEADER_EDIFACT_UNB_3: {
                this.handleStateHeaderTag(input);
                break;
            }
            case HEADER_RELEASE: 
            case DATA_RELEASE: {
                break;
            }
            case ELEMENT_DATA_BINARY: {
                this.handleStateElementDataBinary();
                break;
            }
            case INTERCHANGE_CANDIDATE: {
                this.handleStateInterchangeCandidate(input);
                break;
            }
            case HEADER_DATA: 
            case HEADER_INVALID_DATA: {
                this.handleStateHeaderData((char)input);
                eventsReady = this.dialectConfirmed(State.TAG_SEARCH);
                break;
            }
            case HEADER_SEGMENT_BEGIN: {
                this.dialect.appendHeader(this.characters, (char)input);
                this.openSegment();
                eventsReady = this.dialectConfirmed(State.ELEMENT_END);
                break;
            }
            case HEADER_ELEMENT_END: {
                this.dialect.appendHeader(this.characters, (char)input);
                this.handleElement();
                eventsReady = this.dialectConfirmed(State.ELEMENT_END);
                break;
            }
            case HEADER_COMPONENT_END: {
                this.dialect.appendHeader(this.characters, (char)input);
                this.handleComponent();
                eventsReady = this.dialectConfirmed(State.COMPONENT_END);
                break;
            }
            case SEGMENT_BEGIN: 
            case TRAILER_BEGIN: {
                this.openSegment();
                eventsReady = this.nextEvent();
                break;
            }
            case SEGMENT_END: {
                this.closeSegment();
                eventsReady = this.nextEvent();
                break;
            }
            case SEGMENT_EMPTY: {
                this.emptySegment();
                eventsReady = this.nextEvent();
                break;
            }
            case COMPONENT_END: {
                this.handleComponent();
                eventsReady = this.nextEvent();
                break;
            }
            case ELEMENT_END: 
            case TRAILER_ELEMENT_END: 
            case ELEMENT_REPEAT: {
                this.handleElement();
                eventsReady = this.nextEvent();
                break;
            }
            case INTERCHANGE_END: {
                this.closeInterchange();
                eventsReady = this.nextEvent();
                break;
            }
            default: {
                if (this.characters.isIgnored(input)) {
                    this.state = this.previous;
                    break;
                }
                if (clazz != CharacterClass.INVALID) {
                    throw this.invalidStateError(input, this.state, this.previous);
                }
                throw this.error(EDIException.INVALID_CHARACTER);
            }
        }
        return eventsReady;
    }

    int readCharacterUnchecked() {
        try {
            return this.readCharacter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    int readCharacter() throws IOException {
        int next = this.stream.read();
        if (next < 0) {
            return -1;
        }
        boolean endOfInput = false;
        boolean complete = false;
        int position = 0;
        this.readCharBuf.clear();
        this.readByteBuf.clear();
        this.readByteBuf.put((byte)next);
        do {
            this.readByteBuf.flip();
            CoderResult cr = this.decoder.decode(this.readByteBuf, this.readCharBuf, endOfInput);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (endOfInput) {
                complete = true;
                continue;
            }
            if (this.readCharBuf.position() > 0) {
                complete = true;
                continue;
            }
            next = this.stream.read();
            if (next < 0) {
                endOfInput = true;
                this.decoder.reset();
                continue;
            }
            this.readByteBuf.limit(this.readByteBuf.capacity());
            this.readByteBuf.position(++position);
            this.readByteBuf.put((byte)next);
        } while (!complete);
        if (endOfInput) {
            this.decoder.reset();
        }
        if (this.readCharBuf.position() == 0 && endOfInput) {
            return -1;
        }
        return this.readChar[0];
    }

    void handleStateHeaderTag(int input) {
        this.buffer.put((char)input);
        this.dialect.appendHeader(this.characters, (char)input);
    }

    void handleStateElementDataBinary() {
        if (--this.binaryRemain < 1L) {
            this.state = State.ELEMENT_END_BINARY;
        }
    }

    void handleStateInterchangeCandidate(int input) throws EDIException {
        this.buffer.put((char)input);
        char[] header = this.buffer.array();
        int length = this.buffer.position();
        this.dialect = DialectFactory.getDialect(header, 0, length);
        for (int i = 0; i < length; ++i) {
            this.dialect.appendHeader(this.characters, header[i]);
        }
        this.openInterchange();
        this.openSegment();
    }

    void handleStateHeaderData(char input) throws EDIException {
        this.dialect.appendHeader(this.characters, input);
        switch (this.characters.getClass(input)) {
            case SEGMENT_DELIMITER: {
                this.closeSegment();
                this.state = this.dialect.getTagSearchState();
                break;
            }
            case SEGMENT_TAG_DELIMITER: 
            case ELEMENT_DELIMITER: 
            case ELEMENT_REPEATER: 
            case COMPONENT_DELIMITER: 
            case RELEASE_CHARACTER: {
                break;
            }
            default: {
                if (this.dialect.isDecimalMark(input) || this.characters.isIgnored(input)) break;
                this.buffer.put(input);
            }
        }
    }

    private boolean dialectConfirmed(State confirmed) throws EDIException {
        if (this.dialect.isConfirmed()) {
            this.state = confirmed;
            this.nextEvent();
            return true;
        }
        if (this.dialect.isRejected()) {
            this.buffer.clear();
            this.clearQueues();
            String rejectionMessage = this.dialect.getRejectionMessage();
            this.dialect = null;
            this.state = State.INITIAL;
            throw this.error(EDIException.INVALID_STATE, rejectionMessage);
        }
        return false;
    }

    private EDIException invalidStateError(int input, State state, State previousState) {
        StringBuilder message = new StringBuilder();
        message.append((Object)state);
        message.append(" (previous: ");
        message.append((Object)previousState);
        message.append("); input: '");
        message.append((char)input);
        message.append('\'');
        return this.error(EDIException.INVALID_STATE, message);
    }

    private EDIException error(int code, CharSequence message) {
        return new EDIException(code, message.toString(), this.location.copy());
    }

    private EDIException error(int code) {
        return new EDIException((Integer)code, (Location)this.location.copy());
    }

    private boolean nextEvent() {
        Notifier event = this.events.peek();
        boolean eventsReady = false;
        if (event != null) {
            this.events.remove();
            State nextState = this.stateQueue.remove();
            int start = this.startQueue.remove();
            int length = this.lengthQueue.remove();
            eventsReady = event.execute(nextState, start, length);
            if (this.events.isEmpty()) {
                this.buffer.clear();
            }
        }
        return eventsReady;
    }

    private void enqueue(Notifier task, int position) {
        int length;
        int start;
        if (this.startQueue.isEmpty()) {
            start = 0;
            length = position;
        } else {
            start = this.startQueue.peekLast() + this.lengthQueue.peekLast();
            length = position > 0 ? position - start : 0;
        }
        this.events.add(task);
        this.stateQueue.add(this.state);
        this.startQueue.add(start);
        this.lengthQueue.add(length);
    }

    private void clearQueues() {
        this.events.clear();
        this.stateQueue.clear();
        this.startQueue.clear();
        this.lengthQueue.clear();
    }

    private void openInterchange() {
        this.modes.push(Mode.INTERCHANGE);
        this.enqueue(this.isn, 0);
    }

    private void closeInterchange() throws EDIException {
        this.closeSegment();
        this.popMode(Mode.INTERCHANGE);
        this.enqueue(this.ien, 0);
    }

    private void openSegment() {
        this.modes.push(Mode.SEGMENT);
        this.enqueue(this.ssn, this.buffer.position());
    }

    private void closeSegment() throws EDIException {
        this.handleElement();
        this.popMode(Mode.SEGMENT);
        this.enqueue(this.sen, 0);
    }

    private void emptySegment() throws EDIException {
        this.openSegment();
        this.popMode(Mode.SEGMENT);
        this.enqueue(this.sen, 0);
    }

    private void handleElement() throws EDIException {
        this.location.setRepeating(State.ELEMENT_REPEAT.equals((Object)this.state));
        if (this.previous != State.ELEMENT_END_BINARY) {
            this.addElementEvent();
        }
        if (this.inComposite()) {
            this.closeComposite();
        }
    }

    private void openComposite() {
        this.modes.push(Mode.COMPOSITE);
        this.enqueue(this.csn, 0);
    }

    private void handleComponent() {
        if (!this.inComposite()) {
            this.openComposite();
        }
        this.addElementEvent();
    }

    private void addElementEvent() {
        this.enqueue(this.en, this.buffer.position());
    }

    private boolean inComposite() {
        return this.modes.peek() == Mode.COMPOSITE;
    }

    private void closeComposite() throws EDIException {
        this.popMode(Mode.COMPOSITE);
        this.enqueue(this.cen, 0);
    }

    void popMode(Mode expected) throws EDIException {
        if (this.modes.pop() != expected) {
            throw this.error(EDIException.INVALID_STATE);
        }
    }

    State currentState() {
        return this.state;
    }

    State previousState() {
        return this.previous;
    }

    private static interface Notifier {
        public boolean execute(State var1, int var2, int var3);
    }

    private static enum Mode {
        INTERCHANGE,
        SEGMENT,
        COMPOSITE;

    }
}

