/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.validation.ElementValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.List;

class TimeValidator
extends ElementValidator {
    TimeValidator() {
    }

    @Override
    void validate(Dialect dialect, EDISimpleType element, CharSequence value, List<EDIStreamValidationError> errors) {
        int length = value.length();
        if (!TimeValidator.validateLength(dialect, element, length, errors) || length < 6 && length % 2 != 0 || !TimeValidator.validValue(value)) {
            errors.add(EDIStreamValidationError.INVALID_TIME);
        }
    }

    @Override
    void format(Dialect dialect, EDISimpleType element, CharSequence value, StringBuilder result) {
        int length = value.length();
        result.append(value);
        long min = element.getMinLength();
        for (long i = (long)length; i < min; ++i) {
            result.append('0');
        }
    }

    static boolean validValue(CharSequence value) {
        int length = value.length();
        int hr = 0;
        int mi = 0;
        int se = 0;
        int ds = 0;
        int index = 0;
        block8: for (int i = 0; i < length; ++i) {
            char current = value.charAt(i);
            switch (current) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    return false;
                }
            }
            int digit = Character.digit(current, 10);
            switch (++index) {
                case 1: 
                case 2: {
                    hr = hr * 10 + digit;
                    continue block8;
                }
                case 3: 
                case 4: {
                    mi = mi * 10 + digit;
                    continue block8;
                }
                case 5: 
                case 6: {
                    se = se * 10 + digit;
                    continue block8;
                }
                default: {
                    ds = ds * 10 + digit;
                }
            }
        }
        return hr < 24 && mi < 60 && se < 60;
    }
}

