/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.nio.CharBuffer;

public class StreamEvent {
    private static final String TOSTRING_FORMAT = "type: %s, error: %s, data: %s, typeReference: %s, location: { %s }";
    EDIStreamEvent type;
    EDIStreamValidationError errorType;
    CharBuffer data;
    boolean dataNull = true;
    EDIReference typeReference;
    StaEDIStreamLocation location;

    public void update(EDIStreamEvent type, EDIStreamValidationError errorType, CharSequence data, EDIReference typeReference, StaEDIStreamLocation location) {
        this.type = type;
        this.errorType = errorType;
        this.setData(data);
        this.setTypeReference(typeReference);
        this.setLocation(location);
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.type, this.errorType, this.data, this.typeReference, this.location});
    }

    public EDIStreamEvent getType() {
        return this.type;
    }

    public EDIStreamValidationError getErrorType() {
        return this.errorType;
    }

    public CharBuffer getData() {
        return this.dataNull ? null : this.data;
    }

    public void setData(CharSequence data) {
        if (data != null) {
            this.data = StreamEvent.put(this.data, data);
            this.dataNull = false;
        } else {
            this.dataNull = true;
        }
    }

    public String getReferenceCode() {
        if (this.typeReference instanceof EDITypeImplementation) {
            return ((EDITypeImplementation)this.typeReference).getCode();
        }
        if (this.typeReference != null) {
            return this.typeReference.getReferencedType().getCode();
        }
        return null;
    }

    public EDIReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(EDIReference typeReference) {
        this.typeReference = typeReference;
    }

    public StaEDIStreamLocation getLocation() {
        return this.location;
    }

    public void setLocation(StaEDIStreamLocation location) {
        if (this.location == null) {
            this.location = new StaEDIStreamLocation(location);
        }
        this.location.set(location);
    }

    static CharBuffer put(CharBuffer buffer, CharSequence text) {
        int length = text.length();
        if (buffer == null || buffer.capacity() < length) {
            buffer = CharBuffer.allocate(length);
        }
        buffer.clear();
        if (text instanceof CharArraySequence) {
            if (length > 0) {
                ((CharArraySequence)text).putToBuffer(buffer);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                buffer.put(text.charAt(i));
            }
        }
        buffer.flip();
        return buffer;
    }
}

