/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.ValidationEventHandler;
import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.stream.EDIStreamValidationError;

public class UsageError {
    final EDIReference typeReference;
    final EDIStreamValidationError error;
    final int depth;

    UsageError(EDIReference typeReference, EDIStreamValidationError error, int depth) {
        this.typeReference = typeReference;
        this.error = error;
        this.depth = depth;
    }

    UsageError(EDIStreamValidationError error) {
        this.error = error;
        this.typeReference = null;
        this.depth = -1;
    }

    UsageError(UsageNode node, EDIStreamValidationError error) {
        this.typeReference = node.getLink();
        this.depth = node.getDepth();
        this.error = error;
    }

    boolean isDepthGreaterThan(int depth) {
        return this.depth > depth;
    }

    void handleSegmentError(ValidationEventHandler handler) {
        handler.segmentError(this.typeReference.getReferencedType().getId(), this.typeReference, this.error);
    }

    public EDIReference getTypeReference() {
        return this.typeReference;
    }

    public EDIStreamValidationError getError() {
        return this.error;
    }
}

