/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.json;

import io.xlate.edi.internal.stream.json.StaEDIJsonParser;
import io.xlate.edi.stream.EDIStreamReader;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.Map;

final class StaEDIJakartaJsonParser
extends StaEDIJsonParser<JsonException>
implements JsonParser,
JsonLocation {
    static final JsonParser.Event[] eventMap = (JsonParser.Event[])StaEDIJakartaJsonParser.mapEvents(JsonParser.Event.class);
    static final JsonProvider jsonProvider = JsonProvider.provider();

    StaEDIJakartaJsonParser(EDIStreamReader ediReader, Map<String, Object> properties) {
        super(ediReader, properties);
    }

    @Override
    protected JsonException newJsonException(String message, Throwable cause) {
        return new JsonException(message, cause);
    }

    @Override
    protected JsonException newJsonParsingException(String message, Throwable cause) {
        return new JsonParsingException(message, cause, (JsonLocation)this);
    }

    public JsonLocation getLocation() {
        return this;
    }

    public JsonParser.Event next() {
        return eventMap[this.nextEvent().ordinal()];
    }

    public JsonValue getValue() {
        this.assertEventSet("getValue illegal when data stream has not yet been read");
        switch (this.currentEvent) {
            case START_OBJECT: {
                return this.getObject();
            }
            case START_ARRAY: {
                return this.getArray();
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER: {
                return this.isIntegralNumber() ? jsonProvider.createValue(this.getLong()) : jsonProvider.createValue(this.getBigDecimal());
            }
            case VALUE_STRING: 
            case KEY_NAME: {
                return jsonProvider.createValue(this.getString());
            }
        }
        throw new IllegalStateException("getValue illegal when at current position");
    }

    public JsonArray getArray() {
        this.assertEvent(StaEDIJsonParser.Event.START_ARRAY, current -> "getArray illegal when not at start of array");
        JsonArrayBuilder builder = jsonProvider.createArrayBuilder();
        while (this.nextEvent() != StaEDIJsonParser.Event.END_ARRAY) {
            builder.add(this.getValue());
        }
        return builder.build();
    }

    public JsonObject getObject() {
        StaEDIJsonParser.Event next;
        this.assertEvent(StaEDIJsonParser.Event.START_OBJECT, current -> "getObject illegal when not at start of object");
        JsonObjectBuilder builder = jsonProvider.createObjectBuilder();
        String key = null;
        while ((next = this.nextEvent()) != StaEDIJsonParser.Event.END_OBJECT) {
            if (next == StaEDIJsonParser.Event.KEY_NAME) {
                key = this.getString();
                continue;
            }
            builder.add(key, this.getValue());
        }
        return builder.build();
    }
}

