/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.validation.ElementValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.time.LocalDate;
import java.util.List;

class DateValidator
extends ElementValidator {
    DateValidator() {
    }

    @Override
    void validate(Dialect dialect, EDISimpleType element, CharSequence value, List<EDIStreamValidationError> errors) {
        int length = value.length();
        if (!DateValidator.validateLength(dialect, element, length, errors) || length % 2 != 0 || !DateValidator.validValue(value)) {
            errors.add(EDIStreamValidationError.INVALID_DATE);
        }
    }

    @Override
    void format(Dialect dialect, EDISimpleType element, CharSequence value, StringBuilder result) {
        result.append(value);
    }

    static boolean validValue(CharSequence value) {
        int length = value.length();
        int dateValue = 0;
        block3: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    dateValue = dateValue * 10 + Character.digit(c, 10);
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        int[] date = new int[3];
        date[2] = dateValue % 100;
        date[1] = (dateValue /= 100) % 100;
        date[0] = dateValue /= 100;
        if (length == 6) {
            int year = LocalDate.now().getYear();
            int century = year / 100;
            date[0] = date[0] > year % 100 ? (century - 1) * 100 + date[0] : century * 100 + date[0];
        }
        return DateValidator.dateIsValid(date[0], date[1], date[2]);
    }

    static boolean dateIsValid(int year, int month, int day) {
        if (day < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return day <= 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return day <= 30;
            }
            case 2: {
                return day <= 28 || DateValidator.isLeapYear(year) && day <= 29;
            }
        }
        return false;
    }

    static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }
}

