/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.implementation.LoopImplementation;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StaEDISchema
implements Schema {
    public static final String ID_PREFIX = "io.xlate.edi.internal.schema.";
    public static final String INTERCHANGE_ID = "io.xlate.edi.internal.schema." + EDIType.Type.INTERCHANGE.name();
    public static final String GROUP_ID = "io.xlate.edi.internal.schema." + EDIType.Type.GROUP.name();
    public static final String TRANSACTION_ID = "io.xlate.edi.internal.schema." + EDIType.Type.TRANSACTION.name();
    public static final String IMPLEMENTATION_ID = "io.xlate.edi.internal.schema.IMPLEMENTATION";
    public static final String ANY_ELEMENT_ID = "io.xlate.edi.internal.schema.ANY_ELEMENT";
    public static final String ANY_COMPOSITE_ID = "io.xlate.edi.internal.schema.ANY_COMPOSITE";
    private volatile Integer hash = null;
    final String interchangeName;
    final String transactionStandardName;
    final String implementationName;
    Map<String, EDIType> types = Collections.emptyMap();
    EDIComplexType standardLoop = null;
    LoopImplementation implementationLoop = null;

    public StaEDISchema(String interchangeName, String transactionStandardName, String implementationName) {
        this.interchangeName = interchangeName;
        this.transactionStandardName = transactionStandardName;
        this.implementationName = implementationName;
    }

    public StaEDISchema(String interchangeName, String transactionStandardName) {
        this(interchangeName, transactionStandardName, null);
    }

    public boolean equals(Object o) {
        if (o instanceof Schema) {
            Schema other = (Schema)o;
            return StreamSupport.stream(this.spliterator(), false).filter(type -> {
                EDIType otherType = other.getType(type.getId());
                return !type.equals(otherType);
            }).count() == 0L;
        }
        return false;
    }

    public synchronized int hashCode() {
        Integer localHash = this.hash;
        if (localHash == null) {
            localHash = this.hash = StreamSupport.stream(this.spliterator(), false).collect(Collectors.summingInt((ToIntFunction<EDIType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, hashCode(), (Lio/xlate/edi/schema/EDIType;)I)()));
        }
        return localHash;
    }

    @Override
    public EDIComplexType getStandard() {
        return this.standardLoop;
    }

    @Override
    public LoopImplementation getImplementation() {
        return this.implementationLoop;
    }

    void setTypes(Map<String, EDIType> types) throws EDISchemaException {
        if (types == null) {
            throw new NullPointerException("types cannot be null");
        }
        this.types = Collections.unmodifiableMap(types);
        if (types.containsKey(this.interchangeName)) {
            this.standardLoop = (EDIComplexType)types.get(this.interchangeName);
        } else if (types.containsKey(this.transactionStandardName)) {
            this.standardLoop = (EDIComplexType)types.get(this.transactionStandardName);
        } else {
            throw new EDISchemaException("Schema must contain either " + this.interchangeName + " or " + this.transactionStandardName);
        }
        if (this.implementationName != null && types.containsKey(this.implementationName)) {
            this.implementationLoop = (LoopImplementation)types.get(this.implementationName);
        }
    }

    @Override
    public EDIType getType(String name) {
        return this.types.get(name);
    }

    @Override
    public boolean containsSegment(String name) {
        EDIType type = this.getType(name);
        return type != null && type.isType(EDIType.Type.SEGMENT);
    }

    @Override
    public Iterator<EDIType> iterator() {
        return this.types.values().iterator();
    }
}

