/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.validation.AlphaNumericValidator;
import io.xlate.edi.internal.stream.validation.DateValidator;
import io.xlate.edi.internal.stream.validation.DecimalValidator;
import io.xlate.edi.internal.stream.validation.NumericValidator;
import io.xlate.edi.internal.stream.validation.TimeValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

abstract class ElementValidator {
    ElementValidator() {
    }

    static ElementValidator getInstance(EDISimpleType.Base type) {
        return ValidatorInstances.instances.get((Object)type);
    }

    protected static boolean validateLength(Dialect dialect, EDISimpleType element, int length, List<EDIStreamValidationError> errors) {
        String version = dialect.getTransactionVersionString();
        if ((long)length > element.getMaxLength(version)) {
            errors.add(EDIStreamValidationError.DATA_ELEMENT_TOO_LONG);
            return false;
        }
        if ((long)length < element.getMinLength(version)) {
            errors.add(EDIStreamValidationError.DATA_ELEMENT_TOO_SHORT);
            return false;
        }
        return true;
    }

    abstract void validate(Dialect var1, EDISimpleType var2, CharSequence var3, List<EDIStreamValidationError> var4);

    abstract void format(Dialect var1, EDISimpleType var2, CharSequence var3, StringBuilder var4);

    static class ValidatorInstances {
        static final Map<EDISimpleType.Base, ElementValidator> instances = new EnumMap<EDISimpleType.Base, ElementValidator>(EDISimpleType.Base.class);

        private ValidatorInstances() {
        }

        static {
            instances.put(EDISimpleType.Base.IDENTIFIER, new AlphaNumericValidator());
            instances.put(EDISimpleType.Base.STRING, new AlphaNumericValidator());
            instances.put(EDISimpleType.Base.NUMERIC, new NumericValidator());
            instances.put(EDISimpleType.Base.DECIMAL, new DecimalValidator());
            instances.put(EDISimpleType.Base.DATE, new DateValidator());
            instances.put(EDISimpleType.Base.TIME, new TimeValidator());
        }
    }
}

