/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.ValidationEventHandler;
import io.xlate.edi.internal.stream.validation.ConditionSyntaxValidator;
import io.xlate.edi.internal.stream.validation.ExclusionSyntaxValidator;
import io.xlate.edi.internal.stream.validation.FirstOnlySyntaxValidator;
import io.xlate.edi.internal.stream.validation.ListSyntaxValidator;
import io.xlate.edi.internal.stream.validation.PairedSyntaxValidator;
import io.xlate.edi.internal.stream.validation.RequiredSyntaxValidator;
import io.xlate.edi.internal.stream.validation.SingleSyntaxValidator;
import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

interface SyntaxValidator {
    public static SyntaxValidator getInstance(EDISyntaxRule.Type type) {
        return ValidatorInstances.instances.get((Object)type);
    }

    default public SyntaxStatus scanSyntax(EDISyntaxRule syntax, List<UsageNode> children) {
        SyntaxStatus status = new SyntaxStatus();
        AtomicBoolean anchorPosition = new AtomicBoolean(true);
        syntax.getPositions().stream().filter(position -> position < children.size() + 1).map(position -> (UsageNode)children.get(position - 1)).forEach(node -> {
            if (node.isUsed()) {
                ++status.elementCount;
                if (anchorPosition.get()) {
                    status.anchorPresent = true;
                }
            }
            anchorPosition.set(false);
        });
        return status;
    }

    default public void signalConditionError(EDISyntaxRule syntax, UsageNode structure, ValidationEventHandler handler) {
        List<UsageNode> children = structure.getChildren();
        int limit = children.size() + 1;
        for (int position : syntax.getPositions()) {
            EDIReference typeReference;
            boolean used;
            if (position < limit) {
                UsageNode node = children.get(position - 1);
                used = node.isUsed();
                typeReference = node.getLink();
            } else {
                used = false;
                typeReference = null;
            }
            if (used) continue;
            if (structure.isNodeType(EDIType.Type.SEGMENT, EDIType.Type.COMPOSITE)) {
                SyntaxValidator.signalElementError(structure, typeReference, position, EDIStreamValidationError.CONDITIONAL_REQUIRED_DATA_ELEMENT_MISSING, handler);
                continue;
            }
            if (typeReference == null) continue;
            SyntaxValidator.signalSegmentError(typeReference, EDIStreamValidationError.CONDITIONAL_REQUIRED_SEGMENT_MISSING, handler);
        }
    }

    default public void signalExclusionError(EDISyntaxRule syntax, UsageNode structure, ValidationEventHandler handler) {
        List<UsageNode> children = structure.getChildren();
        int limit = children.size() + 1;
        int tally = 0;
        for (int position : syntax.getPositions()) {
            if (position >= limit || !children.get(position - 1).isUsed() || ++tally <= 1) continue;
            EDIReference typeReference = children.get(position - 1).getLink();
            if (structure.isNodeType(EDIType.Type.SEGMENT, EDIType.Type.COMPOSITE)) {
                SyntaxValidator.signalElementError(structure, typeReference, position, EDIStreamValidationError.EXCLUSION_CONDITION_VIOLATED, handler);
                continue;
            }
            SyntaxValidator.signalSegmentError(typeReference, EDIStreamValidationError.SEGMENT_EXCLUSION_CONDITION_VIOLATED, handler);
        }
    }

    public static void signalElementError(UsageNode structure, EDIReference typeReference, int position, EDIStreamValidationError error, ValidationEventHandler handler) {
        int element = SyntaxValidator.getElementPosition(structure, position);
        int component = SyntaxValidator.getComponentPosition(structure, position);
        handler.elementError(EDIStreamEvent.ELEMENT_OCCURRENCE_ERROR, error, typeReference, null, element, component, -1);
    }

    public static void signalSegmentError(EDIReference typeReference, EDIStreamValidationError error, ValidationEventHandler handler) {
        EDIType type = typeReference.getReferencedType();
        if (!type.isType(EDIType.Type.SEGMENT)) {
            typeReference = ((EDIComplexType)type).getReferences().get(0);
            type = typeReference.getReferencedType();
        }
        handler.segmentError(type.getId(), typeReference, error);
    }

    public static int getComponentPosition(UsageNode structure, int position) {
        return structure.isNodeType(EDIType.Type.COMPOSITE) ? position : -1;
    }

    public static int getElementPosition(UsageNode structure, int position) {
        if (structure.isNodeType(EDIType.Type.COMPOSITE)) {
            return structure.getIndex() + 1;
        }
        return position;
    }

    default public void validate(EDISyntaxRule syntax, UsageNode structure, ValidationEventHandler handler) {
        this.validate(syntax, structure, handler, this.scanSyntax(syntax, structure.getChildren()));
    }

    public void validate(EDISyntaxRule var1, UsageNode var2, ValidationEventHandler var3, SyntaxStatus var4);

    public static class ValidatorInstances {
        static final Map<EDISyntaxRule.Type, SyntaxValidator> instances = new EnumMap<EDISyntaxRule.Type, SyntaxValidator>(EDISyntaxRule.Type.class);

        private ValidatorInstances() {
        }

        static {
            instances.put(EDISyntaxRule.Type.CONDITIONAL, new ConditionSyntaxValidator());
            instances.put(EDISyntaxRule.Type.EXCLUSION, new ExclusionSyntaxValidator());
            instances.put(EDISyntaxRule.Type.FIRSTONLY, new FirstOnlySyntaxValidator());
            instances.put(EDISyntaxRule.Type.LIST, new ListSyntaxValidator());
            instances.put(EDISyntaxRule.Type.PAIRED, new PairedSyntaxValidator());
            instances.put(EDISyntaxRule.Type.REQUIRED, new RequiredSyntaxValidator());
            instances.put(EDISyntaxRule.Type.SINGLE, new SingleSyntaxValidator());
        }
    }

    public static class SyntaxStatus {
        protected int elementCount = 0;
        protected boolean anchorPresent = false;
    }
}

