/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.LocationView;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.DialectFactory;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.tokenization.EventHandler;
import io.xlate.edi.internal.stream.tokenization.State;
import io.xlate.edi.stream.Location;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class Lexer {
    private final Deque<Mode> modes = new ArrayDeque<Mode>();
    private State state = State.INITIAL;
    private State previous;
    private final Deque<Notifier> events = new ArrayDeque<Notifier>(20);
    private final Deque<State> stateQueue = new ArrayDeque<State>(20);
    private final Deque<Integer> startQueue = new ArrayDeque<Integer>(20);
    private final Deque<Integer> lengthQueue = new ArrayDeque<Integer>(20);
    private final InputStream stream;
    private final StaEDIStreamLocation location;
    private CharacterSet characters = new CharacterSet();
    private CharBuffer buffer = CharBuffer.allocate(4096);
    private Dialect dialect;
    private long binaryRemain = -1L;
    private InputStream binaryStream = null;
    private Notifier isn;
    private Notifier ien;
    private Notifier ssn;
    private Notifier sen;
    private Notifier csn;
    private Notifier cen;
    private Notifier en;
    private Notifier bn;

    public Lexer(InputStream stream, EventHandler handler, StaEDIStreamLocation location) {
        this.stream = stream.markSupported() ? stream : new BufferedInputStream(stream);
        this.location = location;
        this.isn = (notifyState, start, length) -> {
            handler.interchangeBegin(this.dialect);
            return true;
        };
        this.ien = (notifyState, start, length) -> {
            handler.interchangeEnd();
            this.dialect = null;
            this.characters.reset();
            return true;
        };
        this.ssn = (notifyState, start, length) -> {
            location.incrementSegmentPosition();
            return handler.segmentBegin(this.buffer.array(), start, length);
        };
        this.sen = (notifyState, start, length) -> {
            boolean eventsReady = handler.segmentEnd();
            location.clearSegmentLocations();
            return eventsReady;
        };
        this.csn = (notifyState, start, length) -> {
            if (location.isRepeated()) {
                location.incrementElementOccurrence();
            } else {
                location.incrementElementPosition();
            }
            return handler.compositeBegin(false);
        };
        this.cen = (notifyState, start, length) -> {
            boolean eventsReady = handler.compositeEnd(false);
            location.clearComponentPosition();
            return eventsReady;
        };
        this.en = (notifyState, start, length) -> {
            Lexer.updateLocation(notifyState, location);
            return handler.elementData(this.buffer.array(), start, length);
        };
        this.bn = (notifyState, start, length) -> {
            Lexer.updateLocation(notifyState, location);
            return handler.binaryData(this.binaryStream);
        };
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setBinaryLength(long binaryLength) {
        this.binaryRemain = binaryLength;
        this.binaryStream = new InputStream(){

            @Override
            public int read() throws IOException {
                int input = -1;
                if (Lexer.this.binaryRemain-- < 1L || (input = Lexer.this.stream.read()) < 0) {
                    Lexer.this.state = State.ELEMENT_END_BINARY;
                } else {
                    Lexer.this.location.incrementOffset(input);
                }
                return input;
            }
        };
        this.enqueue(this.bn, 0);
        this.state = State.ELEMENT_DATA_BINARY;
    }

    public void parse() throws IOException, EDIException {
        int input;
        if (this.nextEvent()) {
            return;
        }
        boolean eventsReady = false;
        block18: while (!eventsReady && (input = this.stream.read()) > -1) {
            this.location.incrementOffset(input);
            CharacterClass clazz = this.characters.getClass(input);
            this.previous = this.state;
            this.state = this.state.transition(clazz);
            switch (this.state) {
                case INITIAL: 
                case TAG_SEARCH: 
                case HEADER_TAG_SEARCH: {
                    continue block18;
                }
                case HEADER_TAG_I: 
                case HEADER_TAG_N: 
                case HEADER_TAG_S: 
                case HEADER_TAG_U: 
                case TAG_1: 
                case TAG_2: 
                case TAG_3: 
                case TRAILER_TAG_I: 
                case TRAILER_TAG_E: 
                case TRAILER_TAG_A: 
                case TRAILER_TAG_U: 
                case TRAILER_TAG_N: 
                case TRAILER_TAG_Z: 
                case ELEMENT_DATA: 
                case ELEMENT_INVALID_DATA: 
                case TRAILER_ELEMENT_DATA: {
                    this.buffer.put((char)input);
                    continue block18;
                }
                case HEADER_TAG_1: 
                case HEADER_TAG_2: 
                case HEADER_TAG_3: {
                    this.handleStateHeaderTag(input);
                    continue block18;
                }
                case DATA_RELEASE: {
                    continue block18;
                }
                case ELEMENT_DATA_BINARY: {
                    this.handleStateElementDataBinary();
                    continue block18;
                }
                case INTERCHANGE_CANDIDATE: {
                    this.handleStateInterchangeCandidate(input);
                    continue block18;
                }
                case HEADER_DATA: {
                    this.handleStateHeaderData(input);
                    eventsReady = this.dialectConfirmed(State.TAG_SEARCH);
                    continue block18;
                }
                case HEADER_SEGMENT_BEGIN: {
                    this.dialect.appendHeader(this.characters, (char)input);
                    this.openSegment();
                    eventsReady = this.dialectConfirmed(State.ELEMENT_END);
                    continue block18;
                }
                case HEADER_ELEMENT_END: {
                    this.dialect.appendHeader(this.characters, (char)input);
                    this.handleElement();
                    eventsReady = this.dialectConfirmed(State.ELEMENT_END);
                    continue block18;
                }
                case HEADER_COMPONENT_END: {
                    this.dialect.appendHeader(this.characters, (char)input);
                    this.handleComponent();
                    eventsReady = this.dialectConfirmed(State.COMPONENT_END);
                    continue block18;
                }
                case SEGMENT_BEGIN: 
                case TRAILER_BEGIN: {
                    this.openSegment();
                    eventsReady = this.nextEvent();
                    continue block18;
                }
                case SEGMENT_END: {
                    this.closeSegment();
                    eventsReady = this.nextEvent();
                    continue block18;
                }
                case SEGMENT_EMPTY: {
                    this.emptySegment();
                    eventsReady = this.nextEvent();
                    continue block18;
                }
                case COMPONENT_END: {
                    this.handleComponent();
                    eventsReady = this.nextEvent();
                    continue block18;
                }
                case ELEMENT_END: 
                case TRAILER_ELEMENT_END: 
                case ELEMENT_REPEAT: {
                    this.handleElement();
                    eventsReady = this.nextEvent();
                    continue block18;
                }
                case INTERCHANGE_END: {
                    this.closeInterchange();
                    eventsReady = this.nextEvent();
                    continue block18;
                }
            }
            if (clazz != CharacterClass.INVALID) {
                StringBuilder message = new StringBuilder();
                message.append(": ");
                message.append((Object)this.state);
                message.append(" (previous: ");
                message.append((Object)this.previous);
                message.append("); input: '");
                message.append((char)input);
                message.append('\'');
                throw this.error(EDIException.INVALID_STATE, message);
            }
            throw this.error(EDIException.INVALID_CHARACTER);
        }
    }

    void handleStateHeaderTag(int input) {
        this.buffer.put((char)input);
        this.dialect.appendHeader(this.characters, (char)input);
    }

    void handleStateElementDataBinary() {
        if (--this.binaryRemain < 1L) {
            this.state = State.ELEMENT_END_BINARY;
        }
    }

    void handleStateInterchangeCandidate(int input) throws EDIException {
        this.stream.mark(500);
        this.buffer.put((char)input);
        char[] header = this.buffer.array();
        int length = this.buffer.position();
        this.dialect = DialectFactory.getDialect(header, 0, length);
        for (int i = 0; i < length; ++i) {
            this.dialect.appendHeader(this.characters, header[i]);
        }
        this.openInterchange();
        this.openSegment();
    }

    void handleStateHeaderData(int input) throws EDIException {
        this.dialect.appendHeader(this.characters, (char)input);
        if (this.characters.isDelimiter(input)) {
            if (this.characters.getDelimiter(CharacterClass.SEGMENT_DELIMITER) == input) {
                this.closeSegment();
                this.state = State.HEADER_TAG_SEARCH;
            }
        } else if (!this.characters.isRelease(input) && this.dialect.getDecimalMark() != input) {
            this.buffer.put((char)input);
        }
    }

    private boolean dialectConfirmed(State confirmed) throws IOException, EDIException {
        if (this.dialect.isConfirmed()) {
            this.state = confirmed;
            this.nextEvent();
            return true;
        }
        if (this.dialect.isRejected()) {
            this.stream.reset();
            this.buffer.clear();
            this.clearQueues();
            this.dialect = null;
            this.state = State.INITIAL;
            throw this.error(EDIException.INVALID_STATE, "Invalid header segment");
        }
        return false;
    }

    private EDIException error(int code, CharSequence message) {
        LocationView where = new LocationView(this.location);
        return new EDIException(code, message.toString(), where);
    }

    private EDIException error(int code) {
        LocationView where = new LocationView(this.location);
        return new EDIException((Integer)code, (Location)where);
    }

    private static void updateLocation(State state, StaEDIStreamLocation location) {
        if (state == State.ELEMENT_REPEAT) {
            if (location.isRepeated()) {
                Lexer.updateElementOccurrence(location);
            } else {
                location.setElementOccurrence(1);
            }
            location.setRepeated(true);
        } else if (location.isRepeated()) {
            if (state != State.COMPONENT_END) {
                Lexer.updateElementOccurrence(location);
                location.setRepeated(false);
            }
        } else {
            location.setElementOccurrence(1);
        }
        switch (state) {
            case HEADER_COMPONENT_END: 
            case COMPONENT_END: {
                location.incrementComponentPosition();
                break;
            }
            default: {
                if (location.getComponentPosition() > 0) {
                    location.incrementComponentPosition();
                    break;
                }
                if (location.getElementOccurrence() != 1) break;
                location.incrementElementPosition();
            }
        }
    }

    static void updateElementOccurrence(StaEDIStreamLocation location) {
        if (location.getComponentPosition() < 1) {
            location.incrementElementOccurrence();
        }
    }

    private boolean nextEvent() {
        Notifier event = this.events.peek();
        boolean eventsReady = false;
        if (event != null) {
            this.events.remove();
            State nextState = this.stateQueue.remove();
            int start = this.startQueue.remove();
            int length = this.lengthQueue.remove();
            eventsReady = event.execute(nextState, start, length);
        }
        if (this.events.isEmpty()) {
            this.buffer.clear();
        }
        return eventsReady;
    }

    private void enqueue(Notifier task, int position) {
        int length;
        int start;
        if (this.startQueue.isEmpty()) {
            start = 0;
            length = position;
        } else {
            start = this.startQueue.peekLast() + this.lengthQueue.peekLast();
            length = position > 0 ? position - start : 0;
        }
        this.events.add(task);
        this.stateQueue.add(this.state);
        this.startQueue.add(start);
        this.lengthQueue.add(length);
    }

    private void clearQueues() {
        this.events.clear();
        this.stateQueue.clear();
        this.startQueue.clear();
        this.lengthQueue.clear();
    }

    private void openInterchange() {
        this.modes.push(Mode.INTERCHANGE);
        this.enqueue(this.isn, 0);
    }

    private void closeInterchange() throws EDIException {
        this.closeSegment();
        this.popMode(Mode.INTERCHANGE);
        this.enqueue(this.ien, 0);
    }

    private void openSegment() {
        this.modes.push(Mode.SEGMENT);
        this.enqueue(this.ssn, this.buffer.position());
    }

    private void closeSegment() throws EDIException {
        this.handleElement();
        this.popMode(Mode.SEGMENT);
        this.enqueue(this.sen, 0);
    }

    private void emptySegment() throws EDIException {
        this.openSegment();
        this.popMode(Mode.SEGMENT);
        this.enqueue(this.sen, 0);
    }

    private void handleElement() throws EDIException {
        if (this.previous != State.ELEMENT_END_BINARY) {
            this.addElementEvent();
        }
        if (this.inComposite()) {
            this.closeComposite();
        }
    }

    private void openComposite() {
        this.modes.push(Mode.COMPOSITE);
        this.enqueue(this.csn, 0);
    }

    private void handleComponent() {
        if (!this.inComposite()) {
            this.openComposite();
        }
        this.addElementEvent();
    }

    private void addElementEvent() {
        this.enqueue(this.en, this.buffer.position());
    }

    private boolean inComposite() {
        return this.modes.peek() == Mode.COMPOSITE;
    }

    private void closeComposite() throws EDIException {
        this.popMode(Mode.COMPOSITE);
        this.enqueue(this.cen, 0);
    }

    void popMode(Mode expected) throws EDIException {
        if (this.modes.pop() != expected) {
            throw this.error(EDIException.INVALID_STATE);
        }
    }

    private static interface Notifier {
        public boolean execute(State var1, int var2, int var3);
    }

    private static enum Mode {
        INTERCHANGE,
        SEGMENT,
        COMPOSITE;

    }
}

