/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;

public class X12Dialect
implements Dialect {
    private static final String ISA = "ISA";
    static final char DFLT_SEGMENT_TERMINATOR = '~';
    static final char DFLT_DATA_ELEMENT_SEPARATOR = '*';
    static final char DFLT_COMPONENT_ELEMENT_SEPARATOR = ':';
    static final char DFLT_REPETITION_SEPARATOR = '^';
    private static final int X12_ISA_LENGTH = 106;
    private static final int X12_ELEMENT_OFFSET = 3;
    private static final int X12_COMPONENT_OFFSET = 104;
    private static final int X12_SEGMENT_OFFSET = 105;
    private static final int X12_REPEAT_OFFSET = 82;
    private static final int[] X12_ISA_TOKENS = new int[]{3, 6, 17, 20, 31, 34, 50, 53, 69, 76, 81, 83, 89, 99, 101, 103};
    private String[] version;
    char[] header;
    private int index = -1;
    private boolean initialized;
    private boolean rejected;
    private char sd = (char)126;
    private char ed = (char)42;
    private char cd = (char)58;
    private char er = (char)94;

    X12Dialect() {
    }

    @Override
    public String getStandard() {
        return "X12";
    }

    @Override
    public String[] getVersion() {
        return this.version;
    }

    boolean initialize(CharacterSet characters) {
        char ELEMENT = this.header[3];
        int e = 0;
        int m = 106;
        for (int i = 0; i < m; ++i) {
            if (ELEMENT != this.header[i] || X12_ISA_TOKENS[e++] == i) continue;
            return false;
        }
        this.cd = this.header[104];
        this.sd = this.header[105];
        this.er = this.header[82];
        characters.setClass(this.cd, CharacterClass.COMPONENT_DELIMITER);
        characters.setClass(this.sd, CharacterClass.SEGMENT_DELIMITER);
        try {
            this.version = new String[]{new String(this.header, 84, 5)};
            if (Integer.parseInt(this.version[0]) >= 402) {
                characters.setClass(this.er, CharacterClass.ELEMENT_REPEATER);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.initialized = true;
        return true;
    }

    @Override
    public void setHeaderTag(String tag) {
    }

    @Override
    public String getHeaderTag() {
        return ISA;
    }

    @Override
    public boolean isConfirmed() {
        return this.initialized;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public boolean appendHeader(CharacterSet characters, char value) {
        ++this.index;
        if (this.index < 106) {
            switch (this.index) {
                case 0: {
                    this.header = new char[106];
                    break;
                }
                case 3: {
                    this.ed = value;
                    characters.setClass(this.ed, CharacterClass.ELEMENT_DELIMITER);
                    break;
                }
            }
            this.header[this.index] = value;
            if (this.index == 105) {
                this.rejected = !this.initialize(characters);
                return this.isConfirmed();
            }
        } else {
            this.rejected = true;
            return false;
        }
        return true;
    }

    @Override
    public char getComponentElementSeparator() {
        return this.cd;
    }

    @Override
    public char getDataElementSeparator() {
        return this.ed;
    }

    @Override
    public char getDecimalMark() {
        return '.';
    }

    @Override
    public char getReleaseIndicator() {
        return '\u0000';
    }

    @Override
    public char getRepetitionSeparator() {
        return this.er;
    }

    @Override
    public char getSegmentTerminator() {
        return this.sd;
    }
}

