/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.SchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;

public class SchemaUtils {
    static Properties controlIndex = new Properties();
    static NavigableMap<String, String> controlVersions = new TreeMap<String, String>();
    static NavigableMap<String, Schema> controlSchemas = new TreeMap<String, Schema>();

    private SchemaUtils() {
    }

    static Enumeration<URL> getStreams(String resource) throws IOException {
        ClassLoader loader = SchemaUtils.class.getClassLoader();
        return loader.getResources(resource);
    }

    static URL getURL(String resource) {
        return SchemaUtils.class.getResource(resource);
    }

    public static Schema getControlSchema(String standard, String[] version) throws EDISchemaException {
        String key = "EDIFACT".equals(standard) ? standard + '.' + version[1] + (version.length > 4 ? '.' + version[4] : "") : standard + '.' + String.join((CharSequence)".", version);
        Map.Entry<String, Schema> controlEntry = controlSchemas.floorEntry(key);
        if (controlEntry != null && controlEntry.getValue() != null) {
            return controlEntry.getValue();
        }
        Map.Entry<String, String> pathEntry = controlVersions.floorEntry(key);
        if (pathEntry != null) {
            Schema created = SchemaUtils.getXmlSchema(pathEntry.getValue());
            controlSchemas.put(pathEntry.getKey(), created);
            return created;
        }
        return null;
    }

    private static Schema getXmlSchema(String resource) throws EDISchemaException {
        SchemaFactory schemaFactory = SchemaFactory.newFactory();
        URL location = SchemaUtils.getURL(resource);
        return schemaFactory.createSchema(location);
    }

    static {
        try {
            Enumeration<URL> resources = SchemaUtils.getStreams("staedi-control-index.properties");
            while (resources.hasMoreElements()) {
                InputStream stream = resources.nextElement().openStream();
                try {
                    controlIndex.load(stream);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (Map.Entry<Object, Object> entry : controlIndex.entrySet()) {
            String standardVersion = entry.getKey().toString();
            String schemaPath = entry.getValue().toString();
            controlVersions.put(standardVersion, schemaPath);
            controlSchemas.put(standardVersion, null);
        }
    }
}

