/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.implementation.LoopImplementation;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

class StaEDISchema
implements Schema {
    final String interchangeName;
    final String transactionStandardName;
    final String implementationName;
    Map<String, EDIType> types = Collections.emptyMap();
    EDIComplexType standardLoop = null;
    LoopImplementation implementationLoop = null;

    public StaEDISchema(String interchangeName, String transactionStandardName, String implementationName) {
        this.interchangeName = interchangeName;
        this.transactionStandardName = transactionStandardName;
        this.implementationName = implementationName;
    }

    public StaEDISchema(String interchangeName, String transactionStandardName) {
        this(interchangeName, transactionStandardName, null);
    }

    @Override
    public EDIComplexType getMainLoop() {
        return this.getStandard();
    }

    @Override
    public EDIComplexType getStandard() {
        return this.standardLoop;
    }

    @Override
    public LoopImplementation getImplementation() {
        return this.implementationLoop;
    }

    void setTypes(Map<String, EDIType> types) throws EDISchemaException {
        if (types == null) {
            throw new NullPointerException("types cannot be null");
        }
        this.types = Collections.unmodifiableMap(types);
        if (types.containsKey(this.interchangeName)) {
            this.standardLoop = (EDIComplexType)types.get(this.interchangeName);
        } else if (types.containsKey(this.transactionStandardName)) {
            this.standardLoop = (EDIComplexType)types.get(this.transactionStandardName);
        } else {
            throw new EDISchemaException("Schema must contain either " + this.interchangeName + " or " + this.transactionStandardName);
        }
        if (this.implementationName != null && types.containsKey(this.implementationName)) {
            this.implementationLoop = (LoopImplementation)types.get(this.implementationName);
        }
    }

    @Override
    public EDIType getType(String name) {
        return this.types.get(name);
    }

    @Override
    public boolean containsSegment(String name) {
        EDIType type = this.types.get(name);
        return type != null && type.isType(EDIType.Type.SEGMENT);
    }

    @Override
    public Iterator<EDIType> iterator() {
        return this.types.values().iterator();
    }
}

