/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.SchemaReaderBase;
import io.xlate.edi.internal.schema.SchemaReaderV2;
import io.xlate.edi.internal.schema.SchemaReaderV3;
import io.xlate.edi.internal.schema.StaEDISchema;
import io.xlate.edi.internal.schema.StaEDISchemaReadException;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.SchemaFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaEDISchemaFactory
implements SchemaFactory {
    static final XMLInputFactory FACTORY = XMLInputFactory.newInstance();
    static final String XMLNS_V2 = "http://xlate.io/EDISchema/v2";
    static final String XMLNS_V3 = "http://xlate.io/EDISchema/v3";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> supportedProperties = new HashSet<String>();

    @Override
    public Schema createSchema(InputStream stream) throws EDISchemaException {
        try {
            SchemaReaderBase schemaReader;
            XMLStreamReader reader = FACTORY.createXMLStreamReader(stream);
            if (reader.getEventType() != 7) {
                throw StaEDISchemaFactory.unexpectedEvent(reader);
            }
            reader.nextTag();
            QName schemaElement = reader.getName();
            if (!"schema".equals(schemaElement.getLocalPart())) {
                throw StaEDISchemaFactory.unexpectedElement(schemaElement, reader);
            }
            if (XMLNS_V2.equals(schemaElement.getNamespaceURI())) {
                schemaReader = new SchemaReaderV2(reader);
            } else if (XMLNS_V3.equals(schemaElement.getNamespaceURI())) {
                schemaReader = new SchemaReaderV3(reader);
            } else {
                throw StaEDISchemaFactory.unexpectedElement(schemaElement, reader);
            }
            Map<String, EDIType> types = schemaReader.readTypes();
            StaEDISchema schema = new StaEDISchema(schemaReader.getInterchangeName(), schemaReader.getTransactionName(), schemaReader.getImplementationName());
            schema.setTypes(types);
            return schema;
        }
        catch (XMLStreamException e) {
            throw new EDISchemaException(e);
        }
        catch (StaEDISchemaReadException e) {
            Location location = e.getLocation();
            if (location != null) {
                throw new EDISchemaException(e.getMessage(), location, e);
            }
            throw new EDISchemaException(e.getMessage(), e);
        }
    }

    @Override
    public Schema createSchema(URL location) throws EDISchemaException {
        Schema schema;
        block8: {
            InputStream stream = location.openStream();
            try {
                schema = this.createSchema(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EDISchemaException("Unable to read URL stream", e);
                }
            }
            stream.close();
        }
        return schema;
    }

    @Override
    public boolean isPropertySupported(String name) {
        return this.supportedProperties.contains(name);
    }

    @Override
    public Object getProperty(String name) {
        if (this.isPropertySupported(name)) {
            return this.properties.get(name);
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.isPropertySupported(name)) {
            this.properties.put(name, value);
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    static StaEDISchemaReadException schemaException(String message) {
        return new StaEDISchemaReadException(message, null, null);
    }

    static StaEDISchemaReadException schemaException(String message, XMLStreamReader reader) {
        return StaEDISchemaFactory.schemaException(message, reader, null);
    }

    static StaEDISchemaReadException unexpectedElement(QName element, XMLStreamReader reader) {
        return StaEDISchemaFactory.schemaException("Unexpected XML element [" + element.toString() + ']', reader);
    }

    static StaEDISchemaReadException unexpectedEvent(XMLStreamReader reader) {
        return StaEDISchemaFactory.schemaException("Unexpected XML event [" + reader.getEventType() + ']', reader);
    }

    static StaEDISchemaReadException schemaException(String message, XMLStreamReader reader, Throwable cause) {
        return new StaEDISchemaReadException(message, reader.getLocation(), cause);
    }
}

