/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.DocumentNamespaceContext;
import io.xlate.edi.stream.EDINamespaces;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamReader;
import io.xlate.edi.stream.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Base64;
import java.util.Deque;
import java.util.Queue;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class StaEDIXMLStreamReader
implements XMLStreamReader {
    private static final QName DUMMY_QNAME = new QName("DUMMY");
    private static final QName INTERCHANGE = new QName("urn:xlate.io:staedi:names:loops", "INTERCHANGE", StaEDIXMLStreamReader.prefixOf("urn:xlate.io:staedi:names:loops"));
    private final EDIStreamReader ediReader;
    private final javax.xml.stream.Location location = new ProxyLocation();
    private boolean autoAdvance;
    private final Queue<Integer> eventQueue = new ArrayDeque<Integer>(3);
    private final Queue<QName> elementQueue = new ArrayDeque<QName>(3);
    private final Deque<QName> elementStack = new ArrayDeque<QName>();
    private NamespaceContext namespaceContext;
    private final StringBuilder cdataBuilder = new StringBuilder();
    private final OutputStream cdataStream = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            StaEDIXMLStreamReader.this.cdataBuilder.append((char)b);
        }
    };
    private char[] cdata;

    StaEDIXMLStreamReader(EDIStreamReader ediReader) throws XMLStreamException {
        this.ediReader = ediReader;
        if (ediReader.getEventType() == EDIStreamEvent.START_INTERCHANGE) {
            this.autoAdvance = false;
            this.enqueueEvent(EDIStreamEvent.START_INTERCHANGE);
        } else {
            this.autoAdvance = true;
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return null;
    }

    private boolean isEvent(int ... eventTypes) {
        return Arrays.stream(eventTypes).anyMatch(this.eventQueue.element()::equals);
    }

    private QName buildName(QName parent, String namespace) {
        return this.buildName(parent, namespace, null);
    }

    private QName buildName(QName parent, String namespace, String name) {
        String prefix = StaEDIXMLStreamReader.prefixOf(namespace);
        if (name == null) {
            Location l = this.ediReader.getLocation();
            int componentPosition = l.getComponentPosition();
            name = componentPosition > 0 ? String.format("%s-%02d", parent.getLocalPart(), componentPosition) : String.format("%s%02d", parent.getLocalPart(), l.getElementPosition());
        }
        return new QName(namespace, name, prefix);
    }

    private void enqueueEvent(int xmlEvent, QName element, boolean remember) {
        this.eventQueue.add(xmlEvent);
        this.elementQueue.add(element);
        if (remember) {
            this.elementStack.addFirst(element);
        }
    }

    private void advanceEvent() {
        if (this.autoAdvance) {
            this.eventQueue.remove();
            this.elementQueue.remove();
        }
        this.autoAdvance = true;
    }

    private void enqueueEvent(EDIStreamEvent ediEvent) throws XMLStreamException {
        this.cdataBuilder.setLength(0);
        this.cdata = null;
        switch (ediEvent) {
            case ELEMENT_DATA: {
                QName name = this.buildName(this.elementStack.getFirst(), "urn:xlate.io:staedi:names:elements");
                this.enqueueEvent(1, name, false);
                this.enqueueEvent(4, DUMMY_QNAME, false);
                this.enqueueEvent(2, name, false);
                break;
            }
            case ELEMENT_DATA_BINARY: {
                QName name = this.buildName(this.elementStack.getFirst(), "urn:xlate.io:staedi:names:elements");
                this.enqueueEvent(1, name, false);
                this.enqueueEvent(12, DUMMY_QNAME, false);
                InputStream input = this.ediReader.getBinaryData();
                byte[] buffer = new byte[4096];
                try (OutputStream output = Base64.getEncoder().wrap(this.cdataStream);){
                    int amount;
                    while ((amount = input.read(buffer)) > -1) {
                        output.write(buffer, 0, amount);
                    }
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
                this.enqueueEvent(2, name, false);
                break;
            }
            case START_INTERCHANGE: {
                this.enqueueEvent(7, DUMMY_QNAME, false);
                this.enqueueEvent(1, INTERCHANGE, true);
                this.namespaceContext = new DocumentNamespaceContext();
                break;
            }
            case START_SEGMENT: {
                QName name = this.buildName(this.elementStack.getFirst(), "urn:xlate.io:staedi:names:segments", this.ediReader.getText());
                this.enqueueEvent(1, name, true);
                break;
            }
            case START_GROUP: 
            case START_TRANSACTION: 
            case START_LOOP: {
                QName name = this.buildName(this.elementStack.getFirst(), "urn:xlate.io:staedi:names:loops", this.ediReader.getText());
                this.enqueueEvent(1, name, true);
                break;
            }
            case START_COMPOSITE: {
                QName name = this.buildName(this.elementStack.getFirst(), "urn:xlate.io:staedi:names:composites", this.ediReader.getReferenceCode());
                this.enqueueEvent(1, name, true);
                break;
            }
            case END_INTERCHANGE: {
                this.enqueueEvent(2, this.elementStack.removeFirst(), false);
                this.namespaceContext = null;
                this.enqueueEvent(8, DUMMY_QNAME, false);
                break;
            }
            case END_GROUP: 
            case END_TRANSACTION: 
            case END_LOOP: 
            case END_SEGMENT: 
            case END_COMPOSITE: {
                this.enqueueEvent(2, this.elementStack.removeFirst(), false);
                break;
            }
            case SEGMENT_ERROR: {
                throw new XMLStreamException(String.format("Segment %s has error %s", new Object[]{this.ediReader.getText(), this.ediReader.getErrorType()}), this.location);
            }
            case ELEMENT_OCCURRENCE_ERROR: {
                throw new XMLStreamException(String.format("Element %s has error %s", new Object[]{this.ediReader.getText(), this.ediReader.getErrorType()}), this.location);
            }
            case ELEMENT_DATA_ERROR: {
                throw new XMLStreamException(String.format("Element %s has error %s", new Object[]{this.ediReader.getText(), this.ediReader.getErrorType()}), this.location);
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)ediEvent));
            }
        }
    }

    private void requireCharacters() {
        if (!this.isCharacters()) {
            throw new IllegalStateException("Text only available for CHARACTERS");
        }
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.eventQueue.isEmpty()) {
            this.advanceEvent();
        }
        if (this.eventQueue.isEmpty()) {
            try {
                this.enqueueEvent(this.ediReader.next());
            }
            catch (XMLStreamException e) {
                throw e;
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
        return this.getEventType();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        int currentType = this.getEventType();
        if (currentType != type) {
            throw new XMLStreamException("Current type " + currentType + " does not match required type " + type);
        }
        if (namespaceURI != null || localName != null) {
            String currentURI;
            String currentLocalPart;
            if (!this.hasName()) {
                throw new XMLStreamException("Current type " + currentType + " does not have a corresponding name");
            }
            QName name = this.getName();
            if (localName != null && !localName.equals(currentLocalPart = name.getLocalPart())) {
                throw new XMLStreamException("Current localPart " + currentLocalPart + " does not match required localName " + localName);
            }
            if (namespaceURI != null && !namespaceURI.equals(currentURI = name.getNamespaceURI())) {
                throw new XMLStreamException("Current namespace " + currentURI + " does not match required namespaceURI " + namespaceURI);
            }
        }
    }

    static XMLStreamException streamException(String message) {
        return new XMLStreamException(message);
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.ediReader.getEventType() != EDIStreamEvent.ELEMENT_DATA) {
            throw StaEDIXMLStreamReader.streamException("Element text only available for simple element");
        }
        if (this.getEventType() != 1) {
            throw StaEDIXMLStreamReader.streamException("Element text only available on START_ELEMENT");
        }
        int eventType = this.next();
        if (eventType != 4) {
            throw StaEDIXMLStreamReader.streamException("Unexpected event type: " + eventType);
        }
        String text = this.getText();
        eventType = this.next();
        if (eventType != 2) {
            throw StaEDIXMLStreamReader.streamException("Unexpected event type after text " + eventType);
        }
        return text;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType;
        while ((eventType = this.next()) != 1 && eventType != 2) {
        }
        return eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        try {
            return this.ediReader.hasNext();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.eventQueue.clear();
            this.elementQueue.clear();
            this.elementStack.clear();
            this.ediReader.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.namespaceContext != null) {
            return this.namespaceContext.getNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public boolean isStartElement() {
        return this.isEvent(1);
    }

    @Override
    public boolean isEndElement() {
        return this.isEvent(2);
    }

    @Override
    public boolean isCharacters() {
        return this.isEvent(4, 12);
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAttributeCount() {
        return 0;
    }

    @Override
    public QName getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeNamespace(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeLocalName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributePrefix(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeType(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNamespaceCount() {
        if (INTERCHANGE.equals(this.elementQueue.element())) {
            return EDINamespaces.all().size();
        }
        return 0;
    }

    @Override
    public String getNamespacePrefix(int index) {
        if (INTERCHANGE.equals(this.elementQueue.element())) {
            String namespace = EDINamespaces.all().get(index);
            return StaEDIXMLStreamReader.prefixOf(namespace);
        }
        return null;
    }

    @Override
    public String getNamespaceURI(int index) {
        if (INTERCHANGE.equals(this.elementQueue.element())) {
            return EDINamespaces.all().get(index);
        }
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public int getEventType() {
        return this.eventQueue.isEmpty() ? -1 : this.eventQueue.element();
    }

    @Override
    public String getText() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            if (this.cdata == null) {
                this.cdata = new char[this.cdataBuilder.length()];
                this.cdataBuilder.getChars(0, this.cdataBuilder.length(), this.cdata, 0);
            }
            return new String(this.cdata);
        }
        return this.ediReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            if (this.cdata == null) {
                this.cdata = new char[this.cdataBuilder.length()];
                this.cdataBuilder.getChars(0, this.cdataBuilder.length(), this.cdata, 0);
            }
            return this.cdata;
        }
        return this.ediReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            if (this.cdata == null) {
                this.cdata = new char[this.cdataBuilder.length()];
                this.cdataBuilder.getChars(0, this.cdataBuilder.length(), this.cdata, 0);
            }
            if (targetStart < 0) {
                throw new IndexOutOfBoundsException("targetStart < 0");
            }
            if (targetStart > target.length) {
                throw new IndexOutOfBoundsException("targetStart > target.length");
            }
            if (length < 0) {
                throw new IndexOutOfBoundsException("length < 0");
            }
            if (targetStart + length > target.length) {
                throw new IndexOutOfBoundsException("targetStart + length > target.length");
            }
            System.arraycopy(this.cdata, sourceStart, target, targetStart, length);
            return length;
        }
        return this.ediReader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            return 0;
        }
        return this.ediReader.getTextStart();
    }

    @Override
    public int getTextLength() {
        this.requireCharacters();
        if (this.cdataBuilder.length() > 0) {
            return this.cdataBuilder.length();
        }
        return this.ediReader.getTextLength();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.isCharacters();
    }

    @Override
    public javax.xml.stream.Location getLocation() {
        return this.location;
    }

    @Override
    public QName getName() {
        if (this.hasName()) {
            return this.elementQueue.element();
        }
        throw new IllegalStateException("Text only available for START_ELEMENT or END_ELEMENT");
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public boolean hasName() {
        return this.isStartElement() || this.isEndElement();
    }

    @Override
    public String getNamespaceURI() {
        if (this.hasName()) {
            return this.elementQueue.element().getNamespaceURI();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    static String prefixOf(String namespace) {
        return String.valueOf(namespace.substring(namespace.lastIndexOf(58) + 1).charAt(0));
    }

    private class ProxyLocation
    implements javax.xml.stream.Location {
        private ProxyLocation() {
        }

        @Override
        public int getLineNumber() {
            return StaEDIXMLStreamReader.this.ediReader.getLocation().getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return StaEDIXMLStreamReader.this.ediReader.getLocation().getColumnNumber();
        }

        @Override
        public int getCharacterOffset() {
            return StaEDIXMLStreamReader.this.ediReader.getLocation().getCharacterOffset();
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    }
}

