/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.schema.SchemaUtils;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.Lexer;
import io.xlate.edi.internal.stream.tokenization.ProxyEventHandler;
import io.xlate.edi.schema.EDISchemaException;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIReporter;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamReader;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class StaEDIStreamReader
implements EDIStreamReader {
    private static final Logger LOGGER = Logger.getLogger(StaEDIStreamReader.class.getName());
    private final InputStream stream;
    private final String encoding;
    private Schema controlSchema;
    private final Map<String, Object> properties;
    private final EDIReporter reporter;
    private final StaEDIStreamLocation location = new StaEDIStreamLocation();
    private final ProxyEventHandler proxy;
    private final Lexer lexer;
    private boolean complete = false;
    private boolean closed = false;

    public StaEDIStreamReader(InputStream stream, String encoding, Schema schema, Map<String, Object> properties, EDIReporter reporter) {
        this.stream = stream;
        this.encoding = encoding;
        this.controlSchema = schema;
        this.properties = new HashMap<String, Object>(properties);
        this.reporter = reporter;
        this.proxy = new ProxyEventHandler(this.location, this.controlSchema);
        this.lexer = new Lexer(this.stream, this.proxy, this.location);
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed");
        }
    }

    private void ensureIncomplete() {
        if (this.complete) {
            throw new NoSuchElementException("Reader is complete");
        }
    }

    private CharBuffer getBuffer() {
        return this.proxy.getCharacters();
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        return this.properties.get(name);
    }

    @Override
    public Map<String, Character> getDelimiters() {
        Dialect dialect = this.lexer.getDialect();
        if (dialect == null) {
            throw new IllegalStateException("getDelimiters must be called within an interchange");
        }
        HashMap<String, Character> delimiters = new HashMap<String, Character>(5);
        delimiters.put("io.xlate.edi.stream.delim.segment", Character.valueOf(dialect.getSegmentTerminator()));
        delimiters.put("io.xlate.edi.stream.delim.dataElement", Character.valueOf(dialect.getDataElementSeparator()));
        delimiters.put("io.xlate.edi.stream.delim.componentElement", Character.valueOf(dialect.getComponentElementSeparator()));
        delimiters.put("io.xlate.edi.stream.delim.decimal", Character.valueOf(dialect.getDecimalMark()));
        if (dialect.getRepetitionSeparator() != '\u0000') {
            delimiters.put("io.xlate.edi.stream.delim.repetition", Character.valueOf(dialect.getRepetitionSeparator()));
        }
        if (dialect.getReleaseIndicator() != '\u0000') {
            delimiters.put("io.xlate.edi.stream.delim.release", Character.valueOf(dialect.getReleaseIndicator()));
        }
        return Collections.unmodifiableMap(delimiters);
    }

    private EDIStreamEvent nextEvent() throws EDIStreamException {
        EDIStreamEvent event;
        this.ensureOpen();
        this.ensureIncomplete();
        if (EDIStreamEvent.START_INTERCHANGE == this.proxy.getEvent() && this.useInternalControlSchema()) {
            try {
                this.setControlSchema(SchemaUtils.getControlSchema(this.getStandard(), this.getVersion()));
            }
            catch (EDISchemaException e) {
                LOGGER.log(Level.WARNING, String.format("Exception loading controlSchema for standard %s, version %s", this.getStandard(), Arrays.stream(this.getVersion()).map(Object::toString).collect(Collectors.joining(", "))), e);
            }
        }
        if (!this.proxy.nextEvent()) {
            this.proxy.resetEvents();
            try {
                this.lexer.parse();
            }
            catch (IOException e) {
                Location where = this.getLocation();
                throw new EDIStreamException("Error parsing input", where, e);
            }
        }
        if ((event = this.proxy.getEvent()) == EDIStreamEvent.END_INTERCHANGE) {
            this.complete = true;
        }
        if (event == EDIStreamEvent.ELEMENT_DATA && this.proxy.isBinaryElementLength()) {
            try {
                this.setBinaryDataLength(Long.parseLong(this.getText()));
            }
            catch (NumberFormatException e) {
                throw new EDIStreamException("Failed to parse binary element length", this.location, e);
            }
        }
        return event;
    }

    @Override
    public EDIStreamEvent next() throws EDIStreamException {
        EDIStreamEvent event = null;
        boolean eventFound = false;
        do {
            event = this.nextEvent();
            if (this.reporter != null && event.isError()) {
                this.reporter.report(this.getErrorType(), this);
                continue;
            }
            eventFound = true;
        } while (!this.complete && !eventFound);
        return event;
    }

    @Override
    public EDIStreamEvent nextTag() throws EDIStreamException {
        EDIStreamEvent event = null;
        boolean tagFound = false;
        do {
            event = this.next();
            switch (event) {
                case START_GROUP: 
                case START_TRANSACTION: 
                case START_LOOP: 
                case START_SEGMENT: {
                    tagFound = true;
                    break;
                }
            }
        } while (!this.complete && !tagFound);
        if (!tagFound) {
            throw new NoSuchElementException("No additional tags in stream");
        }
        return event;
    }

    @Override
    public boolean hasNext() throws EDIStreamException {
        this.ensureOpen();
        return !this.complete;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public EDIStreamEvent getEventType() {
        this.ensureOpen();
        return this.proxy.getEvent();
    }

    @Override
    public String getStandard() {
        if (this.lexer.getDialect() == null || this.lexer.getDialect().getStandard() == null) {
            throw new IllegalStateException("standard not accessible");
        }
        return this.lexer.getDialect().getStandard();
    }

    @Override
    public String[] getVersion() {
        if (this.lexer.getDialect() == null || this.lexer.getDialect().getVersion() == null) {
            throw new IllegalStateException("version not accessible");
        }
        return this.lexer.getDialect().getVersion();
    }

    @Override
    public void setControlSchema(Schema schema) {
        if (this.getEventType() != EDIStreamEvent.START_INTERCHANGE) {
            throw new IllegalStateException("control schema set after interchange start");
        }
        if (this.controlSchema != null) {
            throw new IllegalStateException("control schema already set");
        }
        this.controlSchema = schema;
        this.proxy.setControlSchema(schema, this.validateControlCodeValues());
    }

    @Override
    public void setTransactionSchema(Schema schema) {
        if (!this.proxy.isTransactionSchemaAllowed()) {
            throw new IllegalStateException("Transaction schema can only be set during transaction start");
        }
        this.proxy.setTransactionSchema(schema);
    }

    @Override
    public String getReferenceCode() {
        return this.proxy.getReferenceCode();
    }

    @Override
    public EDIStreamValidationError getErrorType() {
        switch (this.getEventType()) {
            case ELEMENT_DATA_ERROR: 
            case ELEMENT_OCCURRENCE_ERROR: 
            case SEGMENT_ERROR: {
                return this.proxy.getErrorType();
            }
        }
        throw new IllegalStateException("not a valid error state");
    }

    private void checkTextState() {
        EDIStreamEvent event = this.getEventType();
        switch (event) {
            case START_GROUP: 
            case START_TRANSACTION: 
            case START_LOOP: 
            case START_SEGMENT: 
            case ELEMENT_DATA_ERROR: 
            case SEGMENT_ERROR: 
            case END_GROUP: 
            case END_TRANSACTION: 
            case END_LOOP: 
            case END_SEGMENT: 
            case ELEMENT_DATA: {
                break;
            }
            default: {
                throw new IllegalStateException("not a valid text state [" + (Object)((Object)event) + ']');
            }
        }
    }

    @Override
    public String getText() {
        this.ensureOpen();
        this.checkTextState();
        CharBuffer buffer = this.getBuffer();
        return buffer.toString();
    }

    @Override
    public char[] getTextCharacters() {
        this.ensureOpen();
        this.checkTextState();
        CharBuffer buffer = this.getBuffer();
        return Arrays.copyOf(buffer.array(), buffer.length());
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) {
        this.ensureOpen();
        this.checkTextState();
        if (target == null) {
            throw new NullPointerException("Null target array");
        }
        if (targetStart < 0) {
            throw new IndexOutOfBoundsException("targetStart < 0");
        }
        if (targetStart > target.length) {
            throw new IndexOutOfBoundsException("targetStart > target.length");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length < 0");
        }
        if (length > target.length) {
            throw new IndexOutOfBoundsException("length (" + length + ") > target.length (" + target.length + ")");
        }
        CharBuffer buffer = this.getBuffer();
        char[] contents = buffer.array();
        int count = buffer.remaining();
        if (sourceStart < 0) {
            throw new IndexOutOfBoundsException("sourceStart < 0");
        }
        if (sourceStart > count) {
            throw new IndexOutOfBoundsException("sourceStart > source length");
        }
        int toCopy = Math.min(count - sourceStart, length);
        System.arraycopy(contents, sourceStart, target, targetStart, toCopy);
        return toCopy;
    }

    @Override
    public int getTextStart() {
        this.ensureOpen();
        this.checkTextState();
        CharBuffer buffer = this.getBuffer();
        return buffer.position();
    }

    @Override
    public int getTextLength() {
        this.ensureOpen();
        this.checkTextState();
        CharBuffer buffer = this.getBuffer();
        return buffer.limit();
    }

    @Override
    public Location getLocation() {
        this.ensureOpen();
        return this.proxy.getLocation();
    }

    @Override
    public void setBinaryDataLength(long length) throws EDIStreamException {
        this.ensureOpen();
        switch (this.getEventType()) {
            case START_SEGMENT: 
            case ELEMENT_DATA: 
            case END_COMPOSITE: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.lexer.setBinaryLength(length);
    }

    @Override
    public InputStream getBinaryData() {
        this.ensureOpen();
        if (this.getEventType() != EDIStreamEvent.ELEMENT_DATA_BINARY) {
            throw new IllegalStateException();
        }
        return this.proxy.getBinary();
    }

    boolean validateControlCodeValues() {
        return this.getBooleanProperty("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_CODE_VALUES", true);
    }

    boolean useInternalControlSchema() {
        if (this.controlSchema != null) {
            return false;
        }
        return this.getBooleanProperty("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_STRUCTURE", true);
    }

    boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        Object property = this.properties.get(propertyName);
        if (property == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(property.toString());
    }
}

