/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.stream;

import io.xlate.edi.stream.Location;

public class EDIStreamException
extends Exception {
    private static final long serialVersionUID = -1232370584780899896L;
    protected final transient Location location;

    public EDIStreamException(String message) {
        super(message);
        this.location = null;
    }

    public EDIStreamException(Throwable cause) {
        super(cause);
        this.location = null;
    }

    private static String displayLocation(Location location) {
        return location.getSegmentPosition() + " : " + location.getElementPosition();
    }

    public EDIStreamException(String message, Location location, Throwable cause) {
        super("EDIStreamException at [seg,ele]:[" + EDIStreamException.displayLocation(location) + "]\nMessage: " + message, cause);
        this.location = location;
    }

    public EDIStreamException(String message, Location location) {
        super("EDIStreamException at [seg,ele]:[" + EDIStreamException.displayLocation(location) + "]\nMessage: " + message);
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }
}

