/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.ElementDataHandler;
import io.xlate.edi.internal.stream.tokenization.StreamEvent;
import io.xlate.edi.internal.stream.tokenization.ValidationEventHandler;
import io.xlate.edi.internal.stream.validation.SyntaxValidator;
import io.xlate.edi.internal.stream.validation.UsageError;
import io.xlate.edi.internal.stream.validation.UsageNode;
import io.xlate.edi.schema.EDIComplexType;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDISyntaxRule;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.schema.implementation.CompositeImplementation;
import io.xlate.edi.schema.implementation.Discriminator;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import io.xlate.edi.schema.implementation.LoopImplementation;
import io.xlate.edi.schema.implementation.PolymorphicImplementation;
import io.xlate.edi.schema.implementation.SegmentImplementation;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Validator {
    private Schema containerSchema;
    private Schema schema;
    private final boolean validateCodeValues;
    private final UsageNode root;
    private final UsageNode implRoot;
    private boolean segmentExpected;
    private UsageNode segment;
    private UsageNode correctSegment;
    private UsageNode composite;
    private UsageNode element;
    private boolean implSegmentSelected;
    private UsageNode implSegment;
    private UsageNode implComposite;
    private UsageNode implElement;
    private List<UsageNode> implSegmentCandidates = new ArrayList<UsageNode>();
    private final List<UsageError> useErrors = new ArrayList<UsageError>();
    private final List<UsageError> elementErrors = new ArrayList<UsageError>(5);
    private int depth = 1;
    private final UsageCursor cursor = new UsageCursor();

    public Validator(Schema schema, boolean validateCodeValues, Schema containerSchema) {
        this.schema = schema;
        this.validateCodeValues = validateCodeValues;
        this.containerSchema = containerSchema;
        this.root = Validator.buildTree(schema.getStandard());
        this.correctSegment = this.segment = this.root.getFirstChild();
        if (schema.getImplementation() != null) {
            this.implRoot = Validator.buildTree(null, 0, schema.getImplementation(), -1);
            this.implSegment = this.implRoot != null ? this.implRoot.getFirstChild() : null;
        } else {
            this.implRoot = null;
            this.implSegment = null;
        }
    }

    public boolean isPendingDiscrimination() {
        return !this.implSegmentCandidates.isEmpty();
    }

    public String getCompositeReferenceCode() {
        return this.composite != null ? this.composite.getCode() : null;
    }

    public boolean isBinaryElementLength() {
        UsageNode next;
        if (this.element != null && (next = this.element.getNextSibling()) != null && next.isNodeType(EDIType.Type.ELEMENT)) {
            EDISimpleType nextType = (EDISimpleType)next.getReferencedType();
            return nextType.getBase() == EDISimpleType.Base.BINARY;
        }
        return false;
    }

    public String getElementReferenceCode() {
        if (this.composite != null) {
            return this.composite.getCode();
        }
        if (this.element != null) {
            return this.element.getCode();
        }
        return null;
    }

    private static EDIReference referenceOf(final EDIComplexType type, final int minOccurs, final int maxOccurs) {
        return new EDIReference(){

            @Override
            public EDIType getReferencedType() {
                return type;
            }

            @Override
            public int getMinOccurs() {
                return minOccurs;
            }

            @Override
            public int getMaxOccurs() {
                return maxOccurs;
            }
        };
    }

    private static UsageNode buildTree(EDIComplexType root) {
        return Validator.buildTree(null, 0, Validator.referenceOf(root, 1, 1), -1);
    }

    private static UsageNode buildTree(UsageNode parent, int parentDepth, EDIReference link, int index) {
        int depth = parentDepth + 1;
        EDIType referencedNode = link.getReferencedType();
        UsageNode node = new UsageNode(parent, depth, link, index);
        if (!(referencedNode instanceof EDIComplexType)) {
            return node;
        }
        EDIComplexType structure = (EDIComplexType)referencedNode;
        List<EDIReference> children = structure.getReferences();
        List<UsageNode> childUsages = node.getChildren();
        int childIndex = -1;
        for (EDIReference child : children) {
            childUsages.add(Validator.buildTree(node, depth, child, ++childIndex));
        }
        return node;
    }

    private static UsageNode buildTree(UsageNode parent, int parentDepth, EDITypeImplementation impl, int index) {
        List<Object> children;
        if (impl == null) {
            return null;
        }
        int depth = parentDepth + 1;
        UsageNode node = new UsageNode(parent, depth, impl, index);
        switch (impl.getType()) {
            case COMPOSITE: {
                children = ((CompositeImplementation)CompositeImplementation.class.cast(impl)).getSequence();
                break;
            }
            case ELEMENT: {
                children = Collections.emptyList();
                break;
            }
            case TRANSACTION: 
            case LOOP: {
                children = ((LoopImplementation)LoopImplementation.class.cast(impl)).getSequence();
                break;
            }
            case SEGMENT: {
                children = ((SegmentImplementation)SegmentImplementation.class.cast(impl)).getSequence();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal type of EDITypeImplementation: " + (Object)((Object)impl.getType()));
            }
        }
        List<UsageNode> childUsages = node.getChildren();
        int childIndex = -1;
        for (EDITypeImplementation eDITypeImplementation : children) {
            childUsages.add(Validator.buildTree(node, depth, eDITypeImplementation, ++childIndex));
        }
        return node;
    }

    private UsageNode startLoop(UsageNode loop) {
        loop.incrementUsage();
        loop.resetChildren();
        UsageNode startSegment = loop.getFirstChild();
        startSegment.reset();
        startSegment.incrementUsage();
        ++this.depth;
        return startSegment;
    }

    private void completeLoops(ValidationEventHandler handler, int workingDepth) {
        boolean implLoop;
        UsageNode node;
        if (this.implSegment != null) {
            node = this.implSegment;
            implLoop = true;
        } else {
            node = this.correctSegment;
            implLoop = false;
        }
        while (this.depth < workingDepth) {
            this.handleMissingMandatory(handler, workingDepth);
            node = this.completeLoop(handler, node);
            --workingDepth;
        }
        if (implLoop) {
            this.implSegment = node;
        }
    }

    UsageNode completeLoop(ValidationEventHandler handler, UsageNode node) {
        UsageNode parent = node.getParent();
        handler.loopEnd(parent.getCode());
        return parent;
    }

    public void validateSegment(ValidationEventHandler handler, CharSequence tag) {
        this.segmentExpected = true;
        this.implSegmentSelected = false;
        int startDepth = this.depth;
        this.cursor.standard = this.correctSegment;
        this.cursor.impl = this.implSegment;
        this.useErrors.clear();
        boolean handled = false;
        while (!handled && this.cursor.standard != null) {
            handled = this.handleNode(tag, this.cursor.standard, this.cursor.impl, startDepth, handler);
            if (handled) continue;
            this.checkMinimumUsage(this.cursor.standard);
            UsageNode nextImpl = this.checkMinimumImplUsage(this.cursor.impl, this.cursor.standard);
            if (this.cursor.hasNextSibling()) {
                this.cursor.next(nextImpl);
                continue;
            }
            handled = this.checkPeerSegments(tag, this.cursor.standard, startDepth, handler);
            if (handled) continue;
            handled = this.checkParents(this.cursor, tag, startDepth, handler);
        }
        this.handleMissingMandatory(handler);
    }

    UsageNode checkMinimumImplUsage(UsageNode nextImpl, UsageNode current) {
        while (nextImpl != null && nextImpl.getReferencedType().equals(current.getReferencedType())) {
            this.checkMinimumUsage(nextImpl);
            nextImpl = nextImpl.getNextSibling();
        }
        return nextImpl;
    }

    boolean handleNode(CharSequence tag, UsageNode current, UsageNode currentImpl, int startDepth, ValidationEventHandler handler) {
        boolean handled;
        switch (current.getNodeType()) {
            case SEGMENT: {
                handled = this.handleSegment(tag, current, currentImpl, startDepth, handler);
                break;
            }
            case TRANSACTION: 
            case LOOP: 
            case GROUP: {
                handled = this.handleLoop(tag, current, currentImpl, startDepth, handler);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    boolean handleSegment(CharSequence tag, UsageNode current, UsageNode currentImpl, int startDepth, ValidationEventHandler handler) {
        if (!current.getId().contentEquals(tag)) {
            return false;
        }
        if (current.isUsed() && current.isFirstChild() && current.getParent().isNodeType(EDIType.Type.LOOP)) {
            return false;
        }
        this.completeLoops(handler, startDepth);
        current.incrementUsage();
        current.resetChildren();
        if (current.exceedsMaximumUsage()) {
            this.handleMissingMandatory(handler);
            handler.segmentError(current.getId(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
        }
        this.correctSegment = this.segment = current;
        if (currentImpl != null) {
            for (UsageNode impl = currentImpl; impl != null && impl.getReferencedType().equals(current.getReferencedType()); impl = impl.getNextSibling()) {
                this.implSegmentCandidates.add(impl);
            }
            if (this.implSegmentCandidates.isEmpty()) {
                this.handleMissingMandatory(handler);
                handler.segmentError(current.getId(), EDIStreamValidationError.IMPLEMENTATION_UNUSED_SEGMENT_PRESENT);
                this.implSegment = currentImpl;
            } else if (this.implSegmentCandidates.size() == 1) {
                currentImpl.incrementUsage();
                currentImpl.resetChildren();
                if (currentImpl.exceedsMaximumUsage()) {
                    handler.segmentError(currentImpl.getId(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
                }
                this.implSegment = currentImpl;
                this.implSegmentCandidates.clear();
                this.implSegmentSelected = true;
            }
        }
        return true;
    }

    static UsageNode toSegment(UsageNode node) {
        UsageNode segmentNode;
        switch (node.getNodeType()) {
            case SEGMENT: {
                segmentNode = node;
                break;
            }
            case TRANSACTION: 
            case LOOP: 
            case GROUP: {
                segmentNode = node.getFirstChild();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected node type: " + (Object)((Object)node.getNodeType()));
            }
        }
        return segmentNode;
    }

    void checkMinimumUsage(UsageNode node) {
        if (!node.hasMinimumUsage()) {
            UsageNode segmentNode = Validator.toSegment(node);
            String tag = segmentNode.getId();
            if (!segmentNode.isImplementation()) {
                this.useErrors.add(new UsageError(tag, EDIStreamValidationError.MANDATORY_SEGMENT_MISSING, node.getDepth()));
            } else if (node.getNodeType() == EDIType.Type.SEGMENT) {
                this.useErrors.add(new UsageError(tag, EDIStreamValidationError.IMPLEMENTATION_SEGMENT_BELOW_MINIMUM_USE, node.getDepth()));
            } else {
                this.useErrors.add(new UsageError(tag, EDIStreamValidationError.IMPLEMENTATION_LOOP_OCCURS_UNDER_MINIMUM_TIMES, node.getDepth()));
            }
        }
    }

    boolean handleLoop(CharSequence tag, UsageNode current, UsageNode currentImpl, int startDepth, ValidationEventHandler handler) {
        if (!current.getFirstChild().getId().contentEquals(tag)) {
            return false;
        }
        this.completeLoops(handler, startDepth);
        handler.loopBegin(current.getCode());
        this.correctSegment = this.segment = this.startLoop(current);
        if (current.exceedsMaximumUsage()) {
            this.handleMissingMandatory(handler);
            handler.segmentError(tag, EDIStreamValidationError.LOOP_OCCURS_OVER_MAXIMUM_TIMES);
        }
        if (currentImpl != null) {
            for (UsageNode impl = currentImpl; impl != null && impl.getReferencedType().equals(current.getReferencedType()); impl = impl.getNextSibling()) {
                this.implSegmentCandidates.add(impl);
            }
        }
        return true;
    }

    boolean checkPeerSegments(CharSequence tag, UsageNode current, int startDepth, ValidationEventHandler handler) {
        UsageNode next;
        boolean handled = false;
        if (this.depth == startDepth && current != this.correctSegment && (next = current.getSiblingById(tag)) != null && !next.isFirstChild()) {
            this.useErrors.clear();
            handler.segmentError(next.getId(), EDIStreamValidationError.SEGMENT_NOT_IN_PROPER_SEQUENCE);
            next.incrementUsage();
            if (next.exceedsMaximumUsage()) {
                handler.segmentError(next.getId(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
            }
            this.segment = next;
            handled = true;
        }
        return handled;
    }

    boolean checkParents(UsageCursor cursor, CharSequence tag, int startDepth, ValidationEventHandler handler) {
        boolean handled = false;
        if (this.depth > 1) {
            cursor.nagivateUp();
            --this.depth;
        } else {
            cursor.reset(this.root, this.implRoot);
            handled = this.checkUnexpectedSegment(tag, cursor.standard, startDepth, handler);
        }
        return handled;
    }

    boolean checkUnexpectedSegment(CharSequence tag, UsageNode current, int startDepth, ValidationEventHandler handler) {
        boolean handled = false;
        if (!current.getId().contentEquals(tag)) {
            String tagString = tag.toString();
            if (this.containerSchema != null && this.containerSchema.containsSegment(tagString)) {
                this.completeLoops(handler, startDepth);
                this.handleMissingMandatory(handler);
            } else {
                this.segmentExpected = false;
                this.depth = startDepth;
                this.useErrors.clear();
                if (this.schema.containsSegment(tagString)) {
                    handler.segmentError(tag, EDIStreamValidationError.UNEXPECTED_SEGMENT);
                } else {
                    handler.segmentError(tag, EDIStreamValidationError.SEGMENT_NOT_IN_DEFINED_TRANSACTION_SET);
                }
            }
            handled = true;
        }
        return handled;
    }

    private void handleMissingMandatory(ValidationEventHandler handler) {
        for (UsageError error : this.useErrors) {
            error.handle(handler::segmentError);
        }
        this.useErrors.clear();
    }

    private void handleMissingMandatory(ValidationEventHandler handler, int depth) {
        Iterator<UsageError> errors = this.useErrors.iterator();
        while (errors.hasNext()) {
            UsageError e = errors.next();
            if (!e.isDepthGreaterThan(depth)) continue;
            e.handle(handler::segmentError);
            errors.remove();
        }
    }

    public boolean selectImplementation(StreamEvent[] events, int index, int count, ValidationEventHandler handler) {
        StreamEvent currentEvent = events[index + count - 1];
        if (currentEvent.getType() != EDIStreamEvent.ELEMENT_DATA) {
            return false;
        }
        for (UsageNode candidate : this.implSegmentCandidates) {
            UsageNode implSeg = Validator.toSegment(candidate);
            PolymorphicImplementation implType = (PolymorphicImplementation)candidate.getLink();
            if (!Validator.isMatch(implType, currentEvent)) continue;
            this.handleImplementationSelected(candidate, implSeg, handler);
            if (this.implSegment.isFirstChild()) {
                Validator.setLoopReferenceCode(events, index, count - 1, implType);
            }
            return true;
        }
        return false;
    }

    void handleImplementationSelected(UsageNode candidate, UsageNode implSeg, ValidationEventHandler handler) {
        this.checkMinimumImplUsage(this.implSegment, candidate, handler);
        this.implSegmentCandidates.clear();
        this.implSegment = implSeg;
        this.implSegmentSelected = true;
        if (candidate.isNodeType(EDIType.Type.LOOP)) {
            candidate.incrementUsage();
            candidate.resetChildren();
            implSeg.incrementUsage();
            if (candidate.exceedsMaximumUsage()) {
                handler.segmentError(implSeg.getId(), EDIStreamValidationError.LOOP_OCCURS_OVER_MAXIMUM_TIMES);
            }
        } else {
            candidate.incrementUsage();
            if (candidate.exceedsMaximumUsage()) {
                handler.segmentError(implSeg.getId(), EDIStreamValidationError.SEGMENT_EXCEEDS_MAXIMUM_USE);
            }
        }
    }

    void checkMinimumImplUsage(UsageNode sibling, UsageNode selected, ValidationEventHandler handler) {
        while (sibling != null && sibling != selected) {
            this.checkMinimumUsage(sibling);
            sibling = sibling.getNextSibling();
        }
        this.handleMissingMandatory(handler);
    }

    static boolean isMatch(PolymorphicImplementation implType, StreamEvent currentEvent) {
        Discriminator discr = implType.getDiscriminator();
        if (discr.getValueSet().contains(currentEvent.getData().toString())) {
            int eleLoc = discr.getElementPosition();
            int comLoc = discr.getComponentPosition() == 0 ? -1 : discr.getComponentPosition();
            Location location = currentEvent.getLocation();
            if (eleLoc == location.getElementPosition() && comLoc == location.getComponentPosition()) {
                return true;
            }
        }
        return false;
    }

    static void setLoopReferenceCode(StreamEvent[] events, int index, int count, PolymorphicImplementation implType) {
        for (int i = index; i < count; ++i) {
            CharSequence stdRefCode = events[i].getReferenceCode();
            String implRefCode = ((EDIComplexType)implType.getReferencedType()).getCode();
            if (events[i].getType() != EDIStreamEvent.START_LOOP || Validator.compare(stdRefCode, implRefCode) != 0) continue;
            events[i].setReferenceCode(implType.getId());
        }
    }

    static int compare(CharSequence cs1, CharSequence cs2) {
        int len = Math.min(cs1.length(), cs2.length());
        for (int i = 0; i < len; ++i) {
            char b;
            char a = cs1.charAt(i);
            if (a == (b = cs2.charAt(i))) continue;
            return a - b;
        }
        return cs1.length() - cs2.length();
    }

    public List<UsageError> getElementErrors() {
        return this.elementErrors;
    }

    UsageNode getImplElement(int index) {
        if (this.implSegmentSelected) {
            return this.implSegment.getChild(index);
        }
        return null;
    }

    boolean isImplElementSelected() {
        return this.implSegmentSelected && this.implElement != null;
    }

    boolean isImplUnusedElementPresent(boolean valueReceived) {
        return valueReceived && this.implSegmentSelected && this.implElement == null;
    }

    public boolean validCompositeOccurrences(Location position) {
        if (!this.segmentExpected) {
            return true;
        }
        int elementPosition = position.getElementPosition() - 1;
        int componentIndex = position.getComponentPosition() - 1;
        this.elementErrors.clear();
        this.composite = null;
        this.element = this.segment.getChild(elementPosition);
        this.validateImplRepetitions(elementPosition, -1);
        this.implComposite = null;
        this.implElement = this.getImplElement(elementPosition);
        if (this.element == null) {
            this.elementErrors.add(new UsageError(EDIStreamValidationError.TOO_MANY_DATA_ELEMENTS));
            return false;
        }
        if (!this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.element.incrementUsage();
            if (this.element.exceedsMaximumUsage()) {
                this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_REPETITIONS));
                return false;
            }
            return true;
        }
        if (componentIndex > -1) {
            throw new IllegalStateException("Invalid position w/in composite");
        }
        this.composite = this.element;
        this.element = null;
        this.composite.incrementUsage();
        if (this.composite.exceedsMaximumUsage()) {
            this.elementErrors.add(new UsageError(this.composite, EDIStreamValidationError.TOO_MANY_REPETITIONS));
            return false;
        }
        if (!this.validateImplUnusedElementBlank(this.composite, true)) {
            return false;
        }
        this.implComposite = this.implElement;
        this.implElement = null;
        if (this.implSegmentSelected) {
            this.implComposite.incrementUsage();
        }
        return this.elementErrors.isEmpty();
    }

    public boolean isComposite() {
        return this.composite != null;
    }

    public boolean validateElement(Dialect dialect, StaEDIStreamLocation position, CharSequence value) {
        if (!this.segmentExpected) {
            return true;
        }
        boolean valueReceived = value != null && value.length() > 0;
        this.elementErrors.clear();
        this.composite = null;
        this.element = null;
        this.implComposite = null;
        this.implElement = null;
        int elementPosition = position.getElementPosition() - 1;
        int componentIndex = position.getComponentPosition() - 1;
        this.validateImplRepetitions(elementPosition, componentIndex);
        if (elementPosition >= this.segment.getChildren().size()) {
            if (componentIndex < 0) {
                this.elementErrors.add(new UsageError(EDIStreamValidationError.TOO_MANY_DATA_ELEMENTS));
                return false;
            }
            return true;
        }
        this.element = this.segment.getChild(elementPosition);
        this.implElement = this.getImplElement(elementPosition);
        if (this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.composite = this.element;
            this.implComposite = this.implElement;
            if (componentIndex < 0) {
                componentIndex = 0;
            }
        }
        if (componentIndex > -1) {
            this.validateComponentElement(componentIndex, valueReceived);
        } else {
            this.validateImplUnusedElementBlank(this.element, valueReceived);
        }
        if (!this.elementErrors.isEmpty()) {
            return false;
        }
        if (valueReceived) {
            this.validateElementValue(dialect, value);
        } else {
            this.validateDataElementRequirement();
        }
        return this.elementErrors.isEmpty();
    }

    void validateComponentElement(int componentIndex, boolean valueReceived) {
        if (!this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_COMPONENTS));
        } else {
            if (componentIndex == 0) {
                UsageNode.resetChildren(this.element, this.implElement);
            }
            if (componentIndex < this.element.getChildren().size()) {
                if (valueReceived || componentIndex != 0) {
                    this.element = this.element.getChild(componentIndex);
                    if (this.isImplElementSelected()) {
                        this.implElement = this.implElement.getChild(componentIndex);
                        this.validateImplUnusedElementBlank(this.element, valueReceived);
                    }
                }
            } else {
                this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_COMPONENTS));
            }
        }
    }

    void validateElementValue(Dialect dialect, CharSequence value) {
        if (!this.element.isNodeType(EDIType.Type.COMPOSITE)) {
            this.element.incrementUsage();
            if (this.implElement != null) {
                this.implElement.incrementUsage();
            }
            if (this.element.exceedsMaximumUsage()) {
                this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.TOO_MANY_REPETITIONS));
            }
        }
        ArrayList<EDIStreamValidationError> errors = new ArrayList<EDIStreamValidationError>();
        this.element.validate(dialect, value, this.validateCodeValues, errors);
        for (EDIStreamValidationError error : errors) {
            this.elementErrors.add(new UsageError(this.element, error));
        }
        if (errors.isEmpty() && this.implSegmentSelected && this.implElement != null) {
            this.implElement.validate(dialect, value, this.validateCodeValues, errors);
            for (EDIStreamValidationError error : errors) {
                if (error == EDIStreamValidationError.INVALID_CODE_VALUE) {
                    error = EDIStreamValidationError.IMPLEMENTATION_INVALID_CODE_VALUE;
                }
                this.elementErrors.add(new UsageError(this.element, error));
            }
        }
    }

    public void validateSyntax(ElementDataHandler handler, ValidationEventHandler validationHandler, StaEDIStreamLocation location, boolean isComposite) {
        UsageNode previousImpl;
        if (isComposite && this.composite == null) {
            return;
        }
        UsageNode structure = isComposite ? this.composite : this.segment;
        int index = this.getCurrentIndex(location, isComposite);
        int elementPosition = location.getElementPosition() - 1;
        int componentIndex = location.getComponentPosition() - 1;
        List<UsageNode> children = structure.getChildren();
        int max = children.size();
        for (int i = Math.max(index, 0); i < max; ++i) {
            if (isComposite) {
                location.incrementComponentPosition();
            } else {
                location.incrementElementPosition();
            }
            handler.elementData(null, 0, 0);
        }
        if (!isComposite && this.implSegmentSelected && index == children.size() && this.tooFewRepetitions(previousImpl = this.implSegment.getChild(elementPosition))) {
            validationHandler.elementError(EDIStreamValidationError.IMPLEMENTATION_TOO_FEW_REPETITIONS.getCategory(), EDIStreamValidationError.IMPLEMENTATION_TOO_FEW_REPETITIONS, previousImpl.getCode(), elementPosition + 1, componentIndex + 1, -1);
        }
        for (EDISyntaxRule rule : structure.getSyntaxRules()) {
            EDISyntaxRule.Type ruleType = rule.getType();
            SyntaxValidator validator = SyntaxValidator.getInstance(ruleType);
            validator.validate(rule, structure, validationHandler);
        }
    }

    void validateImplRepetitions(int elementPosition, int componentPosition) {
        UsageNode previousImpl;
        if (elementPosition > 0 && componentPosition < 0 && this.tooFewRepetitions(previousImpl = this.getImplElement(elementPosition - 1))) {
            this.elementErrors.add(new UsageError(previousImpl, EDIStreamValidationError.IMPLEMENTATION_TOO_FEW_REPETITIONS));
        }
    }

    boolean validateImplUnusedElementBlank(UsageNode node, boolean valueReceived) {
        if (this.isImplUnusedElementPresent(valueReceived)) {
            this.elementErrors.add(new UsageError(node, EDIStreamValidationError.IMPLEMENTATION_UNUSED_DATA_ELEMENT_PRESENT));
            return false;
        }
        return true;
    }

    void validateDataElementRequirement() {
        if (!UsageNode.hasMinimumUsage(this.element) || !UsageNode.hasMinimumUsage(this.implElement)) {
            this.elementErrors.add(new UsageError(this.element, EDIStreamValidationError.REQUIRED_DATA_ELEMENT_MISSING));
        }
    }

    boolean tooFewRepetitions(UsageNode node) {
        if (!UsageNode.hasMinimumUsage(node)) {
            return node.getLink().getMinOccurs() > 1;
        }
        return false;
    }

    int getCurrentIndex(Location location, boolean isComposite) {
        int componentPosition;
        int index = isComposite ? ((componentPosition = location.getComponentPosition()) < 1 ? 1 : componentPosition) : location.getElementPosition();
        return index;
    }

    static class UsageCursor {
        UsageNode standard;
        UsageNode impl;

        UsageCursor() {
        }

        boolean hasNextSibling() {
            return this.standard.getNextSibling() != null;
        }

        void next(UsageNode nextImpl) {
            this.standard = this.standard.getNextSibling();
            if (nextImpl != null) {
                this.impl = nextImpl;
            }
        }

        void nagivateUp() {
            this.standard = UsageNode.getParent(this.standard);
            this.impl = UsageNode.getParent(this.impl);
        }

        void reset(UsageNode root, UsageNode implRoot) {
            this.standard = UsageNode.getFirstChild(root);
            this.impl = UsageNode.getFirstChild(implRoot);
        }
    }
}

