/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.stream;

import io.xlate.edi.stream.Location;

public class EDIStreamException
extends Exception {
    private static final long serialVersionUID = -1232370584780899896L;
    protected final transient Location location;

    public EDIStreamException(String message) {
        super(message);
        this.location = null;
    }

    public EDIStreamException(Throwable cause) {
        super(cause);
        this.location = null;
    }

    private static String displayLocation(Location location) {
        StringBuilder display = new StringBuilder();
        if (location.getSegmentPosition() < 0) {
            display.append("at offset ");
            display.append(location.getCharacterOffset());
        } else {
            display.append("in segment ");
            if (location.getSegmentTag() != null) {
                display.append(location.getSegmentTag());
            } else {
                display.append("???");
            }
            display.append(" at position ");
            display.append(String.valueOf(location.getSegmentPosition()));
            if (location.getElementPosition() > -1) {
                display.append(", element ");
                display.append(String.valueOf(location.getElementPosition()));
                if (location.getElementOccurrence() > -1) {
                    display.append("(occurrence ");
                    display.append(String.valueOf(location.getElementOccurrence()));
                    display.append(')');
                }
            }
            if (location.getComponentPosition() > -1) {
                display.append(", component ");
                display.append(String.valueOf(location.getComponentPosition()));
            }
        }
        return display.toString();
    }

    public EDIStreamException(String message, Location location, Throwable cause) {
        super(message + " " + EDIStreamException.displayLocation(location), cause);
        this.location = location;
    }

    public EDIStreamException(String message, Location location) {
        super(message + " " + EDIStreamException.displayLocation(location));
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }
}

