/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema.implementation;

import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.implementation.EDITypeImplementation;

public abstract class BaseImpl<T extends EDIType>
implements EDITypeImplementation {
    protected String typeId;
    protected T standard;
    protected int minOccurs = -1;
    protected int maxOccurs = -1;
    protected String title;
    protected String description;

    public BaseImpl(String title, String description) {
        this.title = title;
        this.description = description;
    }

    @Override
    public String getId() {
        return this.typeId;
    }

    @Override
    public EDIType getReferencedType() {
        return this.getStandard();
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public T getStandard() {
        return this.standard;
    }

    public void setStandardReference(EDIReference reference) {
        this.standard = reference.getReferencedType();
        if (this.typeId == null) {
            this.typeId = this.standard.getId();
        }
        if (this.minOccurs < 0) {
            this.minOccurs = reference.getMinOccurs();
        }
        if (this.maxOccurs < 0) {
            this.maxOccurs = reference.getMaxOccurs();
        }
    }
}

