/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema.implementation;

import io.xlate.edi.internal.schema.implementation.BaseImpl;
import io.xlate.edi.internal.schema.implementation.Positioned;
import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.implementation.ElementImplementation;
import java.util.Set;

public class ElementImpl
extends BaseImpl<EDISimpleType>
implements ElementImplementation,
Positioned {
    private static final String TOSTRING_FORMAT = "typeId: %s, minOccurs: %d, maxOccurs: %d, position: %d, values: %s, standard: { %s }";
    private final int position;
    private final Set<String> values;

    public ElementImpl(int minOccurs, int maxOccurs, String typeId, int position, Set<String> values, String title, String description) {
        super(title, description);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.typeId = typeId;
        this.position = position;
        this.values = values;
    }

    public ElementImpl(EDIReference standardReference, int position) {
        super(null, null);
        this.setStandardReference(standardReference);
        this.typeId = ((EDISimpleType)this.standard).getId();
        this.position = position;
        this.values = ((EDISimpleType)this.standard).getValueSet();
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, this.typeId, this.minOccurs, this.maxOccurs, this.position, this.values, this.standard);
    }

    @Override
    public Set<String> getValueSet() {
        return this.values;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public EDISimpleType.Base getBase() {
        return ((EDISimpleType)this.standard).getBase();
    }

    @Override
    public int getNumber() {
        return ((EDISimpleType)this.standard).getNumber();
    }

    @Override
    public long getMinLength() {
        return ((EDISimpleType)this.standard).getMinLength();
    }

    @Override
    public long getMaxLength() {
        return ((EDISimpleType)this.standard).getMaxLength();
    }
}

