/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import java.util.Arrays;

public class CharacterSet {
    private static final CharacterClass _SPACE = CharacterClass.SPACE;
    private static final CharacterClass _LATNA = CharacterClass.LATIN_A;
    private static final CharacterClass _LATNB = CharacterClass.LATIN_B;
    private static final CharacterClass _LATNE = CharacterClass.LATIN_E;
    private static final CharacterClass _LATNI = CharacterClass.LATIN_I;
    private static final CharacterClass _LATNN = CharacterClass.LATIN_N;
    private static final CharacterClass _LATNS = CharacterClass.LATIN_S;
    private static final CharacterClass _LATNU = CharacterClass.LATIN_U;
    private static final CharacterClass _LATNZ = CharacterClass.LATIN_Z;
    private static final CharacterClass _ALNUM = CharacterClass.ALPHANUMERIC;
    private static final CharacterClass _OTHER = CharacterClass.OTHER;
    private static final CharacterClass _WHITE = CharacterClass.WHITESPACE;
    private static final CharacterClass _CNTRL = CharacterClass.CONTROL;
    private static final CharacterClass _INVLD = CharacterClass.INVALID;
    private static final CharacterClass[] prototype = new CharacterClass[]{_INVLD, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _INVLD, _WHITE, _WHITE, _WHITE, _WHITE, _WHITE, _INVLD, _INVLD, _INVLD, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _INVLD, _INVLD, _INVLD, _INVLD, _CNTRL, _CNTRL, _CNTRL, _CNTRL, _SPACE, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _LATNA, _LATNB, _ALNUM, _ALNUM, _LATNE, _ALNUM, _ALNUM, _ALNUM, _LATNI, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _LATNN, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _LATNS, _ALNUM, _LATNU, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _LATNZ, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _OTHER, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _ALNUM, _OTHER, _OTHER, _OTHER, _OTHER, _INVLD};
    private final CharacterClass[] list = Arrays.copyOf(prototype, prototype.length);
    private final int size = this.list.length;

    public CharacterClass getClass(int character) {
        return character < this.size ? this.list[character] : _OTHER;
    }

    public void reset() {
        System.arraycopy(prototype, 0, this.list, 0, prototype.length);
    }

    public void setClass(int character, CharacterClass clazz) {
        if (character >= this.size) {
            throw new ArrayIndexOutOfBoundsException(character);
        }
        this.list[character] = clazz;
    }

    public int getDelimiter(CharacterClass clazz) {
        switch (clazz) {
            case ELEMENT_DELIMITER: 
            case ELEMENT_REPEATER: 
            case SEGMENT_DELIMITER: 
            case COMPONENT_DELIMITER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Nondelimiter class: " + (Object)((Object)clazz));
            }
        }
        int l = this.list.length;
        for (int i = 0; i < l; ++i) {
            if (this.list[i] != clazz) continue;
            return i;
        }
        return -1;
    }

    public boolean isDelimiter(int character) {
        if (character < this.size) {
            switch (this.list[character]) {
                case ELEMENT_DELIMITER: 
                case ELEMENT_REPEATER: 
                case SEGMENT_DELIMITER: 
                case COMPONENT_DELIMITER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isRelease(int character) {
        if (character >= this.size) {
            return false;
        }
        return this.list[character] == CharacterClass.RELEASE_CHARACTER;
    }

    public static boolean isValid(int character) {
        return character >= prototype.length || prototype[character] != _INVLD;
    }
}

