/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.validation.AlphaNumericValidator;
import io.xlate.edi.internal.stream.validation.DateValidator;
import io.xlate.edi.internal.stream.validation.DecimalValidator;
import io.xlate.edi.internal.stream.validation.NumericValidator;
import io.xlate.edi.internal.stream.validation.TimeValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.EDIValidationException;
import java.util.List;

abstract class ElementValidator {
    ElementValidator() {
    }

    static ElementValidator getInstance(EDISimpleType.Base type) {
        switch (type) {
            case IDENTIFIER: 
            case STRING: {
                return AlphaNumericValidator.getInstance();
            }
            case NUMERIC: {
                return NumericValidator.getInstance();
            }
            case DECIMAL: {
                return DecimalValidator.getInstance();
            }
            case DATE: {
                return DateValidator.getInstance();
            }
            case TIME: {
                return TimeValidator.getInstance();
            }
            case BINARY: {
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal type " + (Object)((Object)type));
    }

    protected static boolean validateLength(EDISimpleType element, int length, List<EDIStreamValidationError> errors) {
        if ((long)length > element.getMaxLength()) {
            errors.add(EDIStreamValidationError.DATA_ELEMENT_TOO_LONG);
            return false;
        }
        if ((long)length < element.getMinLength()) {
            errors.add(EDIStreamValidationError.DATA_ELEMENT_TOO_SHORT);
            return false;
        }
        return true;
    }

    protected static void assertMinLength(EDISimpleType element, CharSequence value) {
        if ((long)value.length() < element.getMinLength()) {
            throw new EDIValidationException(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.DATA_ELEMENT_TOO_SHORT, null, value);
        }
    }

    protected static void assertMaxLength(EDISimpleType element, int length, CharSequence value) {
        if ((long)length > element.getMaxLength()) {
            throw new EDIValidationException(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.DATA_ELEMENT_TOO_LONG, null, value);
        }
    }

    protected static void assertMaxLength(EDISimpleType element, CharSequence value) {
        ElementValidator.assertMaxLength(element, value.length(), value);
    }

    abstract void validate(Dialect var1, EDISimpleType var2, CharSequence var3, List<EDIStreamValidationError> var4);

    abstract void format(Dialect var1, EDISimpleType var2, CharSequence var3, Appendable var4) throws EDIException;
}

