/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.stream.Location;

public class X12Dialect
implements Dialect {
    private static final String ISA = "ISA";
    static final char DFLT_SEGMENT_TERMINATOR = '~';
    static final char DFLT_DATA_ELEMENT_SEPARATOR = '*';
    static final char DFLT_COMPONENT_ELEMENT_SEPARATOR = ':';
    static final char DFLT_REPETITION_SEPARATOR = '^';
    private static final int X12_ISA_LENGTH = 106;
    private static final int X12_ELEMENT_OFFSET = 3;
    private static final int X12_COMPONENT_OFFSET = 104;
    private static final int X12_SEGMENT_OFFSET = 105;
    private static final int X12_REPEAT_OFFSET = 82;
    private static final int[] X12_ISA_TOKENS = new int[]{3, 6, 17, 20, 31, 34, 50, 53, 69, 76, 81, 83, 89, 99, 101, 103};
    private String[] version;
    char[] header;
    private int index = -1;
    private boolean initialized;
    private boolean rejected;
    private char sd = (char)126;
    private char ed = (char)42;
    private char cd = (char)58;
    private char er = (char)94;
    private static final int TX_AGENCY = 0;
    private static final int TX_VERSION = 1;
    private String[] transactionVersion = new String[2];
    private String transactionVersionString;
    private String agencyCode;
    private String groupVersion;

    X12Dialect() {
        this.clearTransactionVersion();
    }

    @Override
    public String getStandard() {
        return "X12";
    }

    @Override
    public String[] getVersion() {
        return this.version;
    }

    boolean initialize(CharacterSet characters) {
        char ELEMENT = this.header[3];
        int e = 0;
        int m = 106;
        for (int i = 0; i < m; ++i) {
            if (ELEMENT != this.header[i] || X12_ISA_TOKENS[e++] == i) continue;
            return false;
        }
        this.cd = this.header[104];
        this.sd = this.header[105];
        this.er = this.header[82];
        characters.setClass(this.cd, CharacterClass.COMPONENT_DELIMITER);
        characters.setClass(this.sd, CharacterClass.SEGMENT_DELIMITER);
        try {
            this.version = new String[]{new String(this.header, 84, 5)};
            if (Integer.parseInt(this.version[0]) >= 402) {
                characters.setClass(this.er, CharacterClass.ELEMENT_REPEATER);
            } else {
                this.er = '\u0000';
            }
        }
        catch (NumberFormatException nfe) {
            this.er = '\u0000';
        }
        this.initialized = true;
        return true;
    }

    @Override
    public void setHeaderTag(String tag) {
    }

    @Override
    public String getHeaderTag() {
        return ISA;
    }

    @Override
    public boolean isConfirmed() {
        return this.initialized;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public boolean isServiceAdviceSegment(String tag) {
        return false;
    }

    @Override
    public boolean appendHeader(CharacterSet characters, char value) {
        ++this.index;
        if (this.index < 106) {
            switch (this.index) {
                case 0: {
                    this.header = new char[106];
                    break;
                }
                case 3: {
                    this.ed = value;
                    characters.setClass(this.ed, CharacterClass.ELEMENT_DELIMITER);
                    break;
                }
            }
            this.header[this.index] = value;
            if (this.index == 105) {
                this.rejected = !this.initialize(characters);
                return this.isConfirmed();
            }
        } else {
            this.rejected = true;
            return false;
        }
        return true;
    }

    @Override
    public char getComponentElementSeparator() {
        return this.cd;
    }

    @Override
    public char getDataElementSeparator() {
        return this.ed;
    }

    @Override
    public char getDecimalMark() {
        return '.';
    }

    @Override
    public char getReleaseIndicator() {
        return '\u0000';
    }

    @Override
    public char getRepetitionSeparator() {
        return this.er;
    }

    @Override
    public char getSegmentTerminator() {
        return this.sd;
    }

    void clearTransactionVersion() {
        this.agencyCode = "";
        this.groupVersion = "";
        this.transactionVersion[0] = this.agencyCode;
        this.transactionVersion[1] = this.groupVersion;
        this.updateTransactionVersionString(null);
    }

    void updateTransactionVersionString(String[] transactionVersion) {
        this.transactionVersionString = transactionVersion != null ? String.join((CharSequence)".", transactionVersion) : "";
    }

    @Override
    public void elementData(CharSequence data, Location location) {
        if ("GS".equals(location.getSegmentTag())) {
            switch (location.getElementPosition()) {
                case 1: {
                    this.clearTransactionVersion();
                    break;
                }
                case 7: {
                    this.agencyCode = data.toString();
                    break;
                }
                case 8: {
                    this.groupVersion = data.toString();
                    this.transactionVersion[0] = this.agencyCode;
                    this.transactionVersion[1] = this.groupVersion;
                    this.updateTransactionVersionString(this.transactionVersion);
                    break;
                }
            }
        } else if ("ST".equals(location.getSegmentTag()) && location.getElementPosition() == 3 && data.length() > 0) {
            this.transactionVersion[1] = data.toString();
            this.updateTransactionVersionString(this.transactionVersion);
        }
    }

    @Override
    public void transactionEnd() {
        this.transactionVersion[1] = this.groupVersion;
        this.updateTransactionVersionString(this.transactionVersion);
    }

    @Override
    public void groupEnd() {
        this.clearTransactionVersion();
    }

    @Override
    public String[] getTransactionVersion() {
        return this.transactionVersion;
    }

    @Override
    public String getTransactionVersionString() {
        return this.transactionVersionString;
    }
}

