/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.StaEDIFilteredStreamReader;
import io.xlate.edi.internal.stream.StaEDIStreamReader;
import io.xlate.edi.internal.stream.StaEDIXMLStreamReader;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIInputFactory;
import io.xlate.edi.stream.EDIReporter;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamFilter;
import io.xlate.edi.stream.EDIStreamReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaEDIInputFactory
extends EDIInputFactory {
    private EDIReporter reporter;

    public StaEDIInputFactory() {
        this.supportedProperties.add("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_STRUCTURE");
        this.supportedProperties.add("io.xlate.edi.stream.EDI_VALIDATE_CONTROL_CODE_VALUES");
        this.supportedProperties.add("io.xlate.edi.stream.XML_DECLARE_TRANSACTION_XMLNS");
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream) {
        return this.createEDIStreamReader(stream, (Schema)null);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, String encoding) throws EDIStreamException {
        return this.createEDIStreamReader(stream, encoding, null);
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, Schema schema) {
        return new StaEDIStreamReader(stream, StandardCharsets.UTF_8, schema, this.properties, this.getEDIReporter());
    }

    @Override
    public EDIStreamReader createEDIStreamReader(InputStream stream, String encoding, Schema schema) throws EDIStreamException {
        Objects.requireNonNull(stream);
        if (Charset.isSupported(encoding)) {
            return new StaEDIStreamReader(stream, Charset.forName(encoding), schema, this.properties, this.getEDIReporter());
        }
        throw new EDIStreamException("Unsupported encoding: " + encoding);
    }

    @Override
    public EDIStreamReader createFilteredReader(EDIStreamReader reader, EDIStreamFilter filter) {
        return new StaEDIFilteredStreamReader(reader, filter);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(EDIStreamReader reader) throws XMLStreamException {
        return new StaEDIXMLStreamReader(reader, this.properties);
    }

    @Override
    public EDIReporter getEDIReporter() {
        return this.reporter;
    }

    @Override
    public void setEDIReporter(EDIReporter reporter) {
        this.reporter = reporter;
    }
}

