/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.CharArraySequence;
import io.xlate.edi.internal.stream.StaEDIStreamLocation;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.nio.CharBuffer;

public class StreamEvent {
    private static final String TOSTRING_FORMAT = "type: %s, error: %s, data: %s, referenceCode: %s, location: { %s }";
    EDIStreamEvent type;
    EDIStreamValidationError errorType;
    CharBuffer data;
    boolean dataNull = true;
    CharBuffer referenceCode;
    boolean referenceCodeNull = true;
    StaEDIStreamLocation location;

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.type, this.errorType, this.data, this.referenceCode, this.location});
    }

    public EDIStreamEvent getType() {
        return this.type;
    }

    public CharBuffer getData() {
        return this.dataNull ? null : this.data;
    }

    public void setData(CharSequence data) {
        if (data instanceof CharArraySequence) {
            this.data = StreamEvent.put(this.data, (CharArraySequence)data);
            this.dataNull = false;
        } else if (data != null) {
            this.data = StreamEvent.put(this.data, data);
            this.dataNull = false;
        } else {
            this.dataNull = true;
        }
    }

    public CharSequence getReferenceCode() {
        return this.referenceCodeNull ? null : this.referenceCode;
    }

    public String getReferenceCodeString() {
        return this.referenceCodeNull ? null : this.referenceCode.toString();
    }

    public void setReferenceCode(CharSequence referenceCode) {
        this.referenceCodeNull = referenceCode == null;
        this.referenceCode = !this.referenceCodeNull ? StreamEvent.put(this.referenceCode, referenceCode) : StreamEvent.put(this.referenceCode, "");
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        if (this.location == null) {
            this.location = new StaEDIStreamLocation(location);
        }
        this.location.set(location);
    }

    static CharBuffer put(CharBuffer buffer, CharArraySequence data) {
        int length = data.length();
        if (buffer == null || buffer.capacity() < length) {
            buffer = CharBuffer.allocate(length);
        }
        buffer.clear();
        if (length > 0) {
            data.putToBuffer(buffer);
        }
        buffer.flip();
        return buffer;
    }

    static CharBuffer put(CharBuffer buffer, CharSequence text) {
        int length = text.length();
        if (buffer == null || buffer.capacity() < length) {
            buffer = CharBuffer.allocate(length);
        }
        buffer.clear();
        for (int i = 0; i < length; ++i) {
            buffer.put(text.charAt(i));
        }
        buffer.flip();
        return buffer;
    }
}

