/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema;

import io.xlate.edi.internal.schema.BasicType;
import io.xlate.edi.internal.schema.VersionedProperty;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.schema.EDIType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class ElementType
extends BasicType
implements EDISimpleType {
    private static final String TOSTRING_FORMAT = "id: %s, type: %s, base: %s, code: %s, minLength: %d, maxLength: %d, values: %s";
    final EDISimpleType.Base base;
    final String code;
    final int number;
    final long minLength;
    final long maxLength;
    final Set<String> values;
    final List<Version> versions;

    ElementType(String id, EDISimpleType.Base base, String code, int number, long minLength, long maxLength, Set<String> values, List<Version> versions) {
        super(id, EDIType.Type.ELEMENT);
        this.base = base;
        this.code = code;
        this.number = number;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.values = Collections.unmodifiableSet(new LinkedHashSet<String>(values));
        this.versions = Collections.unmodifiableList(new ArrayList<Version>(versions));
    }

    <T> T getVersionAttribute(String version, BiFunction<Version, ElementType, T> versionedSupplier, Supplier<T> defaultSupplier) {
        for (Version ver : this.versions) {
            if (!ver.appliesTo(version)) continue;
            return versionedSupplier.apply(ver, this);
        }
        return defaultSupplier.get();
    }

    public String toString() {
        return String.format(TOSTRING_FORMAT, new Object[]{this.getId(), this.getType(), this.base, this.code, this.minLength, this.maxLength, this.values});
    }

    @Override
    public EDISimpleType.Base getBase() {
        return this.base;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean hasVersions() {
        return !this.versions.isEmpty();
    }

    @Override
    @Deprecated
    public int getNumber() {
        return this.number;
    }

    @Override
    public long getMinLength() {
        return this.minLength;
    }

    @Override
    public long getMinLength(String version) {
        return this.getVersionAttribute(version, Version::getMinLength, this::getMinLength);
    }

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public long getMaxLength(String version) {
        return this.getVersionAttribute(version, Version::getMaxLength, this::getMaxLength);
    }

    @Override
    public Set<String> getValueSet() {
        return this.values;
    }

    @Override
    public Set<String> getValueSet(String version) {
        return this.getVersionAttribute(version, Version::getValueSet, this::getValueSet);
    }

    static class Version
    extends VersionedProperty {
        final Long minLength;
        final Long maxLength;
        final Set<String> values;

        Version(String minVersion, String maxVersion, Long minLength, Long maxLength, Set<String> values) {
            super(minVersion, maxVersion);
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.values = values;
        }

        public long getMinLength(ElementType defaultElement) {
            return this.minLength != null ? this.minLength.longValue() : defaultElement.getMinLength();
        }

        public long getMaxLength(ElementType defaultElement) {
            return this.maxLength != null ? this.maxLength.longValue() : defaultElement.getMaxLength();
        }

        public Set<String> getValueSet(ElementType defaultElement) {
            return this.values != null ? this.values : defaultElement.getValueSet();
        }
    }
}

