/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.Schema;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamFilter;
import io.xlate.edi.stream.EDIStreamReader;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.Location;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

class StaEDIFilteredStreamReader
implements EDIStreamReader {
    private final EDIStreamReader delegate;
    private final EDIStreamFilter filter;
    private EDIStreamEvent peekEvent = null;

    public StaEDIFilteredStreamReader(EDIStreamReader delegate, EDIStreamFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public Map<String, Character> getDelimiters() {
        return this.delegate.getDelimiters();
    }

    @Override
    public EDIStreamEvent next() throws EDIStreamException {
        EDIStreamEvent event;
        if (this.peekEvent != null) {
            EDIStreamEvent event2 = this.peekEvent;
            this.peekEvent = null;
            return event2;
        }
        do {
            event = this.delegate.next();
        } while (!this.filter.accept(this.delegate));
        return event;
    }

    @Override
    public EDIStreamEvent nextTag() throws EDIStreamException {
        EDIStreamEvent event;
        if (this.peekEvent == EDIStreamEvent.START_SEGMENT) {
            this.peekEvent = null;
            return EDIStreamEvent.START_SEGMENT;
        }
        do {
            event = this.delegate.nextTag();
        } while (!this.filter.accept(this.delegate));
        return event;
    }

    @Override
    public boolean hasNext() throws EDIStreamException {
        while (this.delegate.hasNext()) {
            EDIStreamEvent event = this.delegate.next();
            if (!this.filter.accept(this.delegate)) continue;
            this.peekEvent = event;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public EDIStreamEvent getEventType() {
        return this.delegate.getEventType();
    }

    @Override
    public String getStandard() {
        return this.delegate.getStandard();
    }

    @Override
    public String[] getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public String[] getTransactionVersion() {
        return this.delegate.getTransactionVersion();
    }

    @Override
    public String getTransactionVersionString() {
        return this.delegate.getTransactionVersionString();
    }

    @Override
    public Schema getControlSchema() {
        return this.delegate.getControlSchema();
    }

    @Override
    public void setControlSchema(Schema schema) {
        this.delegate.setControlSchema(schema);
    }

    @Override
    public Schema getTransactionSchema() {
        return this.delegate.getTransactionSchema();
    }

    @Override
    public void setTransactionSchema(Schema schema) {
        this.delegate.setTransactionSchema(schema);
    }

    @Override
    public String getReferenceCode() {
        return this.delegate.getReferenceCode();
    }

    @Override
    public EDIStreamValidationError getErrorType() {
        return this.delegate.getErrorType();
    }

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.delegate.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) {
        return this.delegate.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.delegate.getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.delegate.getTextLength();
    }

    @Override
    public Location getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public void setBinaryDataLength(long length) throws EDIStreamException {
        this.delegate.setBinaryDataLength(length);
    }

    @Override
    public InputStream getBinaryData() {
        return this.delegate.getBinaryData();
    }

    @Override
    public EDIReference getSchemaTypeReference() {
        return this.delegate.getSchemaTypeReference();
    }
}

