/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream;

import io.xlate.edi.internal.stream.StaEDIStreamWriter;
import io.xlate.edi.internal.stream.StaEDIXMLStreamWriter;
import io.xlate.edi.stream.EDIOutputErrorReporter;
import io.xlate.edi.stream.EDIOutputFactory;
import io.xlate.edi.stream.EDIStreamException;
import io.xlate.edi.stream.EDIStreamWriter;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamWriter;

public class StaEDIOutputFactory
extends EDIOutputFactory {
    private EDIOutputErrorReporter reporter;

    public StaEDIOutputFactory() {
        this.supportedProperties.add("io.xlate.edi.stream.delim.segment");
        this.supportedProperties.add("io.xlate.edi.stream.delim.dataElement");
        this.supportedProperties.add("io.xlate.edi.stream.delim.componentElement");
        this.supportedProperties.add("io.xlate.edi.stream.delim.repetition");
        this.supportedProperties.add("io.xlate.edi.stream.delim.decimal");
        this.supportedProperties.add("io.xlate.edi.stream.delim.release");
        this.supportedProperties.add("io.xlate.edi.stream.PRETTY_PRINT");
        this.supportedProperties.add("io.xlate.edi.stream.TRUNCATE_EMPTY_ELEMENTS");
        this.properties.put("io.xlate.edi.stream.PRETTY_PRINT", Boolean.FALSE);
    }

    @Override
    public EDIStreamWriter createEDIStreamWriter(OutputStream stream) {
        return new StaEDIStreamWriter(stream, StandardCharsets.UTF_8, this.properties, this.reporter);
    }

    @Override
    public EDIStreamWriter createEDIStreamWriter(OutputStream stream, String encoding) throws EDIStreamException {
        if (Charset.isSupported(encoding)) {
            return new StaEDIStreamWriter(stream, Charset.forName(encoding), this.properties, this.reporter);
        }
        throw new EDIStreamException("Unsupported encoding: " + encoding);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(EDIStreamWriter writer) {
        return new StaEDIXMLStreamWriter(writer);
    }

    @Override
    public EDIOutputErrorReporter getErrorReporter() {
        return this.reporter;
    }

    @Override
    public void setErrorReporter(EDIOutputErrorReporter reporter) {
        this.reporter = reporter;
    }
}

