/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.tokenization;

import io.xlate.edi.internal.stream.tokenization.CharacterClass;
import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.stream.Location;

public class EDIFACTDialect
extends Dialect {
    public static final String UNA = "UNA";
    public static final String UNB = "UNB";
    private static final String[] EMPTY = new String[0];
    private static final int EDIFACT_UNA_LENGTH = 9;
    private String headerTag;
    private String[] version;
    StringBuilder header;
    private int index = -1;
    private int unbStart = -1;
    private boolean initialized;
    private boolean rejected;
    private static final int TX_AGENCY = 0;
    private static final int TX_VERSION = 1;
    private static final int TX_RELEASE = 2;
    private static final int TX_ASSIGNED_CODE = 3;
    private String[] transactionVersion = new String[4];
    private String transactionVersionString;

    EDIFACTDialect() {
        this.componentDelimiter = (char)58;
        this.elementDelimiter = (char)43;
        this.decimalMark = (char)46;
        this.releaseIndicator = (char)63;
        this.elementRepeater = (char)42;
        this.segmentDelimiter = (char)39;
        this.clearTransactionVersion();
    }

    @Override
    public void setHeaderTag(String tag) {
        this.headerTag = tag;
    }

    @Override
    public String getHeaderTag() {
        return this.headerTag;
    }

    boolean initialize(CharacterSet characters) {
        String[] parsedVersion = this.parseVersion();
        if (parsedVersion.length > 0) {
            this.version = parsedVersion;
            characters.setClass(this.componentDelimiter, CharacterClass.COMPONENT_DELIMITER);
            characters.setClass(this.elementDelimiter, CharacterClass.ELEMENT_DELIMITER);
            if (this.releaseIndicator != ' ') {
                characters.setClass(this.releaseIndicator, CharacterClass.RELEASE_CHARACTER);
            }
            if (this.elementRepeater != ' ') {
                characters.setClass(this.elementRepeater, CharacterClass.ELEMENT_REPEATER);
            }
            characters.setClass(this.segmentDelimiter, CharacterClass.SEGMENT_DELIMITER);
            this.initialized = true;
        } else {
            this.initialized = false;
        }
        return this.initialized;
    }

    private String[] parseVersion() {
        int versionStart = EDIFACTDialect.findVersionStart(this.headerTag, this.header, this.elementDelimiter);
        if (versionStart > -1) {
            StringBuilder versionBuilder = new StringBuilder();
            int i = versionStart;
            while (this.header.charAt(i) != this.elementDelimiter) {
                versionBuilder.append(this.header.charAt(i));
                ++i;
            }
            return versionBuilder.toString().split('\\' + String.valueOf(this.componentDelimiter));
        }
        return EMPTY;
    }

    static int findVersionStart(String headerTag, StringBuilder header, char elementDelimiter) {
        int versionStart;
        block3: {
            int length;
            block2: {
                length = header.length();
                versionStart = -1;
                if (!UNB.equals(headerTag)) break block2;
                if (length < 10) break block3;
                versionStart = 4;
                break block3;
            }
            if (length >= 18) {
                for (int i = 11; i < length; ++i) {
                    if (!EDIFACTDialect.unbTag(header, i - 2) || length < i + 7 || header.charAt(i + 1) != elementDelimiter) continue;
                    versionStart = i + 2;
                    break;
                }
            }
        }
        return versionStart;
    }

    static boolean unbTag(StringBuilder buffer, int position) {
        return buffer.charAt(position) == 'U' && buffer.charAt(position + 1) == 'N' && buffer.charAt(position + 2) == 'B';
    }

    @Override
    public boolean isConfirmed() {
        return this.initialized;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public boolean isServiceAdviceSegment(String tag) {
        return UNA.equals(tag);
    }

    @Override
    public String getStandard() {
        return "EDIFACT";
    }

    @Override
    public String[] getVersion() {
        return this.version;
    }

    @Override
    public boolean appendHeader(CharacterSet characters, char value) {
        if (++this.index == 0) {
            this.header = new StringBuilder();
        }
        this.header.append(value);
        if (UNB.equals(this.headerTag)) {
            return this.processInterchangeHeader(characters, value);
        }
        return this.processServiceStringAdvice(characters, value);
    }

    boolean processInterchangeHeader(CharacterSet characters, char value) {
        if (this.index == 0) {
            characters.setClass(this.componentDelimiter, CharacterClass.COMPONENT_DELIMITER);
            characters.setClass(this.releaseIndicator, CharacterClass.RELEASE_CHARACTER);
            characters.setClass(this.elementRepeater, CharacterClass.ELEMENT_REPEATER);
            return true;
        }
        if (this.index == 3) {
            characters.setClass(this.elementDelimiter, CharacterClass.ELEMENT_DELIMITER);
            return true;
        }
        if (this.segmentDelimiter == value) {
            characters.setClass(this.segmentDelimiter, CharacterClass.SEGMENT_DELIMITER);
            this.rejected = !this.initialize(characters);
            return this.isConfirmed();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean processServiceStringAdvice(CharacterSet characters, char value) {
        switch (this.index) {
            case 3: {
                this.componentDelimiter = value;
                this.setCharacterClass(characters, CharacterClass.COMPONENT_DELIMITER, value, true);
                break;
            }
            case 4: {
                this.elementDelimiter = value;
                this.setCharacterClass(characters, CharacterClass.ELEMENT_DELIMITER, value, true);
                break;
            }
            case 5: {
                this.decimalMark = value;
                break;
            }
            case 6: {
                this.releaseIndicator = value;
                this.setCharacterClass(characters, CharacterClass.RELEASE_CHARACTER, value, false);
                break;
            }
            case 7: {
                this.elementRepeater = value;
                this.setCharacterClass(characters, CharacterClass.ELEMENT_REPEATER, value, false);
                break;
            }
            case 8: {
                this.segmentDelimiter = value;
                this.setCharacterClass(characters, CharacterClass.SEGMENT_DELIMITER, value, true);
                break;
            }
        }
        if (this.index <= 9) return true;
        if (this.unbStart > -1 && this.index - this.unbStart > 9) {
            this.rejected = !this.initialize(characters);
            return this.isConfirmed();
        }
        if (this.header.charAt(this.index) == 'B') {
            CharSequence un = this.header.subSequence(this.index - 2, this.index);
            if (!"UN".contentEquals(un)) return false;
            this.unbStart = this.index - 2;
            return true;
        } else {
            if (this.unbStart >= 0 || value != this.elementDelimiter) return true;
            return false;
        }
    }

    void setCharacterClass(CharacterSet characters, CharacterClass charClass, char value, boolean allowSpace) {
        if (value != ' ' || allowSpace) {
            characters.setClass(value, charClass);
        }
    }

    void clearTransactionVersion() {
        for (int i = 0; i < this.transactionVersion.length; ++i) {
            this.transactionVersion[i] = "";
        }
        this.updateTransactionVersionString(null);
    }

    void updateTransactionVersionString(String[] transactionVersion) {
        this.transactionVersionString = transactionVersion != null ? String.join((CharSequence)".", transactionVersion) : "";
    }

    @Override
    public void elementData(CharSequence data, Location location) {
        if ("UNH".equals(location.getSegmentTag())) {
            if (location.getElementPosition() == 1) {
                this.clearTransactionVersion();
            } else if (location.getElementPosition() == 2) {
                switch (location.getComponentPosition()) {
                    case 2: {
                        this.transactionVersion[1] = data.toString();
                        break;
                    }
                    case 3: {
                        this.transactionVersion[2] = data.toString();
                        break;
                    }
                    case 4: {
                        this.transactionVersion[0] = data.toString();
                        this.updateTransactionVersionString(this.transactionVersion);
                        break;
                    }
                    case 5: {
                        this.transactionVersion[3] = data.toString();
                        this.updateTransactionVersionString(this.transactionVersion);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void transactionEnd() {
        this.clearTransactionVersion();
    }

    @Override
    public void groupEnd() {
        this.clearTransactionVersion();
    }

    @Override
    public String[] getTransactionVersion() {
        return this.transactionVersionString.isEmpty() ? null : this.transactionVersion;
    }

    @Override
    public String getTransactionVersionString() {
        return this.transactionVersionString;
    }
}

