/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.stream;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PropertySupport {
    protected final Set<String> supportedProperties = new HashSet<String>();
    protected final Map<String, Object> properties = new HashMap<String, Object>();

    protected PropertySupport() {
    }

    public boolean isPropertySupported(String name) {
        return this.supportedProperties.contains(name);
    }

    public Object getProperty(String name) {
        if (!this.isPropertySupported(name)) {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (!this.isPropertySupported(name)) {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
        this.properties.put(name, value);
    }
}

