/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.schema.implementation;

import io.xlate.edi.schema.EDIReference;
import io.xlate.edi.schema.EDIType;
import io.xlate.edi.schema.implementation.EDITypeImplementation;
import java.util.Objects;

public abstract class BaseImpl<T extends EDIType>
implements EDITypeImplementation {
    protected String typeId;
    protected T standard;
    protected int minOccurs = -1;
    protected int maxOccurs = -1;
    protected String title;
    protected String description;

    public BaseImpl(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isInstance(o)) {
            return false;
        }
        BaseImpl other = (BaseImpl)o;
        return Objects.equals(this.typeId, other.typeId) && Objects.equals(this.standard, other.standard) && Objects.equals(this.minOccurs, other.minOccurs) && Objects.equals(this.maxOccurs, other.maxOccurs) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hash(this.typeId, this.standard, this.minOccurs, this.maxOccurs, this.title, this.description);
    }

    @Override
    public String getId() {
        return this.typeId;
    }

    @Override
    public String getCode() {
        return this.typeId;
    }

    @Override
    public EDIType getReferencedType() {
        return this.getStandard();
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public T getStandard() {
        return this.standard;
    }

    public void setStandardReference(EDIReference reference) {
        this.standard = reference.getReferencedType();
        if (this.typeId == null) {
            this.typeId = this.standard.getId();
        }
        if (this.minOccurs < 0) {
            this.minOccurs = reference.getMinOccurs();
        }
        if (this.maxOccurs < 0) {
            this.maxOccurs = reference.getMaxOccurs();
        }
    }
}

