/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.CharacterSet;
import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.validation.ElementValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.EDIValidationException;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class AlphaNumericValidator
extends ElementValidator {
    private static final AlphaNumericValidator singleton = new AlphaNumericValidator();

    private AlphaNumericValidator() {
    }

    static AlphaNumericValidator getInstance() {
        return singleton;
    }

    @Override
    void validate(Dialect dialect, EDISimpleType element, CharSequence value, List<EDIStreamValidationError> errors) {
        int length = value.length();
        AlphaNumericValidator.validateLength(dialect, element, length, errors);
        Set<String> valueSet = element.getValueSet(dialect.getTransactionVersionString());
        if (!valueSet.isEmpty() && !valueSet.contains(value.toString())) {
            errors.add(EDIStreamValidationError.INVALID_CODE_VALUE);
        } else {
            for (int i = 0; i < length; ++i) {
                char character = value.charAt(i);
                if (CharacterSet.isValid(character)) continue;
                errors.add(EDIStreamValidationError.INVALID_CHARACTER_DATA);
                break;
            }
        }
    }

    @Override
    void format(Dialect dialect, EDISimpleType element, CharSequence value, Appendable result) throws EDIException {
        int length = value.length();
        AlphaNumericValidator.assertMaxLength(element, value);
        Set<String> valueSet = element.getValueSet();
        if (!valueSet.isEmpty() && !valueSet.contains(value.toString())) {
            throw new EDIValidationException(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.INVALID_CODE_VALUE, null, value);
        }
        try {
            for (int i = 0; i < length; ++i) {
                char character = value.charAt(i);
                if (!CharacterSet.isValid(character)) {
                    throw new EDIException(EDIException.INVALID_CHARACTER, "Invalid character 0x" + String.format("%04X", character));
                }
                result.append(character);
            }
            long min = element.getMinLength();
            for (long i = (long)length; i < min; ++i) {
                result.append(' ');
            }
        }
        catch (IOException e) {
            throw new EDIException(e);
        }
    }
}

