/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.edi.internal.stream.validation;

import io.xlate.edi.internal.stream.tokenization.Dialect;
import io.xlate.edi.internal.stream.tokenization.EDIException;
import io.xlate.edi.internal.stream.validation.ElementValidator;
import io.xlate.edi.schema.EDISimpleType;
import io.xlate.edi.stream.EDIStreamEvent;
import io.xlate.edi.stream.EDIStreamValidationError;
import io.xlate.edi.stream.EDIValidationException;
import java.io.IOException;
import java.util.List;

class TimeValidator
extends ElementValidator {
    private static final TimeValidator singleton = new TimeValidator();

    private TimeValidator() {
    }

    static TimeValidator getInstance() {
        return singleton;
    }

    @Override
    void validate(Dialect dialect, EDISimpleType element, CharSequence value, List<EDIStreamValidationError> errors) {
        int length = value.length();
        if (!TimeValidator.validateLength(dialect, element, length, errors) || !TimeValidator.validValue(value)) {
            errors.add(EDIStreamValidationError.INVALID_TIME);
        }
    }

    @Override
    void format(Dialect dialect, EDISimpleType element, CharSequence value, Appendable result) throws EDIException {
        int length = value.length();
        TimeValidator.assertMaxLength(element, value);
        if (!TimeValidator.validValue(value)) {
            throw new EDIValidationException(EDIStreamEvent.ELEMENT_DATA, EDIStreamValidationError.INVALID_TIME, null, value);
        }
        try {
            result.append(value);
            long min = element.getMinLength();
            for (long i = (long)length; i < min; ++i) {
                result.append('0');
            }
        }
        catch (IOException e) {
            throw new EDIException(e);
        }
    }

    static boolean validValue(CharSequence value) {
        int length = value.length();
        int hr = 0;
        int mi = 0;
        int se = 0;
        int ds = 0;
        int index = 0;
        block8: for (int i = 0; i < length; ++i) {
            char current = value.charAt(i);
            switch (current) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    return false;
                }
            }
            int digit = Character.digit(current, 10);
            switch (++index) {
                case 1: 
                case 2: {
                    hr = hr * 10 + digit;
                    continue block8;
                }
                case 3: 
                case 4: {
                    mi = mi * 10 + digit;
                    continue block8;
                }
                case 5: 
                case 6: {
                    se = se * 10 + digit;
                    continue block8;
                }
                default: {
                    ds = ds * 10 + digit;
                }
            }
        }
        return hr < 24 && mi < 60 && se < 60;
    }
}

