/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.validation.internal.constraintvalidators;

import jakarta.el.BeanNameResolver;
import jakarta.el.ELProcessor;
import jakarta.validation.ConstraintDeclarationException;

public interface BooleanExpression {
    default public boolean evaluate(ELProcessor processor, String expression, Boolean exceptionalValue) {
        if (!expression.isEmpty()) {
            Object result;
            try {
                result = processor.eval(expression);
            }
            catch (Exception e) {
                if (exceptionalValue != null) {
                    result = exceptionalValue;
                }
                throw e;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new ConstraintDeclarationException("Expression `" + expression + "` does not evaluate to Boolean");
        }
        return true;
    }

    default public BeanNameResolver newNameResolver(final Object target, final String targetName) {
        return new BeanNameResolver(){

            public boolean isNameResolved(String beanName) {
                return targetName.equals(beanName);
            }

            public Object getBean(String beanName) {
                return this.isNameResolved(beanName) ? target : null;
            }
        };
    }
}

