/*
 * Decompiled with CFR 0.152.
 */
package io.xlate.validation.internal.constraintvalidators;

import io.xlate.validation.constraints.DateTime;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DateTimeValidator
implements ConstraintValidator<DateTime, CharSequence> {
    private List<Object> formatters;
    private DateTime.ParserType formatterType;

    public void initialize(DateTime constraintAnnotation) {
        this.formatterType = constraintAnnotation.parserType();
        DateTime annotation = constraintAnnotation;
        String[] patterns = annotation.patterns();
        if (patterns.length == 0) {
            throw new ConstraintDeclarationException("At least one DateFormat pattern must be provided.");
        }
        this.formatters = this.formatterType == DateTime.ParserType.JAVA_TEXT ? Arrays.stream(patterns).map(p -> this.toJavaTextDateFormat((String)p, annotation)).collect(Collectors.toList()) : Arrays.stream(patterns).map(p -> this.toJavaTimeDateTimeFormatter((String)p, annotation)).collect(Collectors.toList());
    }

    public boolean isValid(CharSequence sequence, ConstraintValidatorContext context) {
        if (sequence == null || sequence.length() == 0) {
            return true;
        }
        if (this.formatterType == DateTime.ParserType.JAVA_TEXT) {
            String value = sequence.toString();
            for (DateFormat format : this.formatters()) {
                DateFormat localFormat = (DateFormat)format.clone();
                try {
                    localFormat.parse(value);
                    return true;
                }
                catch (ParseException parseException) {
                }
            }
        } else {
            for (DateTimeFormatter formatter : this.formatters()) {
                try {
                    formatter.parse(sequence);
                    return true;
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        return false;
    }

    private <T> List<T> formatters() {
        return this.formatters;
    }

    private DateFormat toJavaTextDateFormat(String pattern, DateTime annotation) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setLenient(annotation.lenient());
            return format;
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintDeclarationException("Invalid format pattern `" + pattern + "`", (Throwable)e);
        }
    }

    private DateTimeFormatter toJavaTimeDateTimeFormatter(String pattern, DateTime annotation) {
        try {
            return new DateTimeFormatterBuilder().appendPattern(pattern).toFormatter().withResolverStyle(annotation.resolverStyle());
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintDeclarationException("Invalid format pattern `" + pattern + "`", (Throwable)e);
        }
    }
}

